/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.util.math;

public final class OperationUtils {
    private static final double Epsilon = 1.0E-6;

    public static int compare(double value1, double value2) {
        return OperationUtils.compare(value1, value2, 1.0E-6);
    }

    public static int compare(double value1, double value2, double epsilon) {
        double difference = value1 - value2;
        int exponent = Math.getExponent(Math.max(value1, value2));
        double delta = Math.scalb(epsilon, exponent);
        if (difference > delta) {
            return 1;
        }
        if (difference < -delta) {
            return -1;
        }
        return 0;
    }

    public static int compare(byte[] data1, byte[] data2) {
        int index = 0;
        int length = data1.length;
        while (index < length) {
            switch ((int)Math.signum((data1[index] & 0xFF) - (data2[index] & 0xFF))) {
                case -1: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
            }
            ++index;
        }
        return 0;
    }

    public static void increment(byte[] data) {
        OperationUtils.increment(data, data.length - 1);
    }

    public static void increment(byte[] data, int position) {
        if ((data[position] & 0xFF) == 255) {
            data[position] = 0;
            OperationUtils.increment(data, position - 1);
        } else {
            int n = position;
            data[n] = (byte)(data[n] + 1);
        }
    }
}

