/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.util;

import java.nio.ByteOrder;

public final class ConvertUtils {
    private static final char[] HexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String byteArrayToHex(byte[] data) {
        int dataLength = data.length;
        char[] result = new char[dataLength * 2];
        int dataIndex = 0;
        int resultIndex = 0;
        while (dataIndex < dataLength) {
            result[resultIndex++] = HexDigits[(0xF0 & data[dataIndex]) >>> 4];
            result[resultIndex++] = HexDigits[0xF & data[dataIndex]];
            ++dataIndex;
        }
        return new String(result);
    }

    public static int byteArrayToInt(byte[] data) {
        return ConvertUtils.byteArrayToInt(data, 0, ByteOrder.BIG_ENDIAN);
    }

    public static int byteArrayToInt(byte[] data, int index, ByteOrder byteOrder) throws ArrayIndexOutOfBoundsException {
        return ConvertUtils.byteArrayToNumber(data, index, 4, byteOrder);
    }

    public static int byteArrayToNumber(byte[] data, int index, int length, ByteOrder byteOrder) throws ArrayIndexOutOfBoundsException {
        length = Math.min(length, data.length - index);
        int value = 0;
        int i = index;
        int endIndex = index + length;
        while (i < endIndex) {
            value |= (data[i] & 0xFF) << 8 * (byteOrder == ByteOrder.LITTLE_ENDIAN ? i - index : endIndex - i - 1);
            ++i;
        }
        return value;
    }

    public static byte[] hexToByteArray(String data) {
        char[] dataChars = data.toCharArray();
        int dataLength = dataChars.length;
        if (dataLength % 2 != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] result = new byte[dataLength / 2];
        int resultIndex = 0;
        int dataIndex = 0;
        while (dataIndex < dataLength) {
            result[resultIndex] = (byte)((ConvertUtils.toHexDigit(dataChars[dataIndex++]) << 4 | ConvertUtils.toHexDigit(dataChars[dataIndex++])) & 0xFF);
            ++resultIndex;
        }
        return result;
    }

    public static byte[] intToByteArray(int data) {
        return new byte[]{(byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
    }

    public static byte[] numberToByteArray(int data, int length, ByteOrder byteOrder) {
        byte[] result = new byte[length];
        int index = 0;
        while (index < length) {
            result[index] = (byte)(data >> 8 * (byteOrder == ByteOrder.LITTLE_ENDIAN ? index : length - index - 1));
            ++index;
        }
        return result;
    }

    public static float[] toFloatArray(double[] array) {
        float[] result = new float[array.length];
        int index = 0;
        int length = array.length;
        while (index < length) {
            result[index] = (float)array[index];
            ++index;
        }
        return result;
    }

    private static int toHexDigit(char dataChar) {
        int digit = Character.digit(dataChar, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + dataChar);
        }
        return digit;
    }
}

