/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

public final class XRefEntry
implements Cloneable {
    public static final int GenerationUnreusable = 65535;
    public static final int UndefinedOffset = -1;
    private int number;
    private int generation;
    private int offset;
    private int streamNumber;
    private UsageEnum usage;

    public XRefEntry(int number, int generation) {
        this(number, generation, -1, UsageEnum.InUse);
    }

    public XRefEntry(int number, int generation, int offset, UsageEnum usage) {
        this(number, generation, offset, usage, -1);
    }

    public XRefEntry(int number, int offset, int streamNumber) {
        this(number, 0, offset, UsageEnum.InUseCompressed, streamNumber);
    }

    private XRefEntry(int number, int generation, int offset, UsageEnum usage, int streamNumber) {
        this.number = number;
        this.generation = generation;
        this.offset = offset;
        this.usage = usage;
        this.streamNumber = streamNumber;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getNumber() {
        return this.number;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public UsageEnum getUsage() {
        return this.usage;
    }

    public void setGeneration(int value) {
        this.generation = value;
    }

    public void setNumber(int value) {
        this.number = value;
    }

    public void setOffset(int value) {
        this.offset = value;
    }

    public void setStreamNumber(int value) {
        this.streamNumber = value;
    }

    public void setUsage(UsageEnum value) {
        this.usage = value;
    }

    protected XRefEntry clone() throws CloneNotSupportedException {
        return (XRefEntry)super.clone();
    }

    public static enum UsageEnum {
        Free,
        InUse,
        InUseCompressed;

    }
}

