/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import java.text.DecimalFormat;
import java.util.Map;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.files.IndirectObjects;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.tokens.Chunk;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.tokens.FileParser;
import org.pdfclown.tokens.Writer;
import org.pdfclown.util.NotImplementedException;

final class PlainWriter
extends Writer {
    private static final byte[] TrailerChunk = Encoding.Pdf.encode("trailer\n");
    private static final String XRefChunk = "xref\n";
    private static final String XRefEOLChunk = "\r\n";
    private static final DecimalFormat XRefGenerationFormatter = new DecimalFormat("00000");
    private static final DecimalFormat XRefOffsetFormatter = new DecimalFormat("0000000000");

    PlainWriter(File file, IOutputStream stream) {
        super(file, stream);
    }

    @Override
    protected void writeIncremental() {
        FileParser parser = this.file.getReader().getParser();
        this.stream.write(parser.getStream());
        int xrefSize = this.file.getIndirectObjects().size();
        StringBuilder xrefBuilder = new StringBuilder(XRefChunk);
        StringBuilder xrefSubBuilder = new StringBuilder();
        int xrefSubCount = 0;
        int prevKey = 0;
        for (Map.Entry<Integer, PdfIndirectObject> indirectObjectEntry : this.file.getIndirectObjects().getModifiedObjects().entrySet()) {
            if (indirectObjectEntry.getKey() - prevKey == 1 || prevKey == 0) {
                ++xrefSubCount;
            } else {
                this.appendXRefSubsection(xrefBuilder, prevKey - xrefSubCount + 1, xrefSubCount, xrefSubBuilder);
                xrefSubBuilder.setLength(0);
                xrefSubCount = 1;
            }
            prevKey = indirectObjectEntry.getKey();
            if (indirectObjectEntry.getValue().isInUse()) {
                this.appendXRefEntry(xrefSubBuilder, indirectObjectEntry.getValue().getReference(), this.stream.getLength());
                indirectObjectEntry.getValue().writeTo(this.stream, this.file);
                continue;
            }
            this.appendXRefEntry(xrefSubBuilder, indirectObjectEntry.getValue().getReference(), 0L);
        }
        this.appendXRefSubsection(xrefBuilder, prevKey - xrefSubCount + 1, xrefSubCount, xrefSubBuilder);
        long startxref = this.stream.getLength();
        this.stream.write(xrefBuilder.toString());
        this.writeTrailer(startxref, xrefSize, parser);
    }

    @Override
    protected void writeLinearized() {
        throw new NotImplementedException();
    }

    @Override
    protected void writeStandard() {
        this.writeHeader();
        int xrefSize = this.file.getIndirectObjects().size();
        StringBuilder xrefBuilder = new StringBuilder(XRefChunk);
        this.appendXRefSubsectionIndexer(xrefBuilder, 0, xrefSize);
        StringBuilder xrefInUseBlockBuilder = new StringBuilder();
        IndirectObjects indirectObjects = this.file.getIndirectObjects();
        PdfReference freeReference = indirectObjects.get(0).getReference();
        int index = 1;
        while (index < xrefSize) {
            PdfIndirectObject indirectObject = indirectObjects.get(index);
            if (indirectObject.isInUse()) {
                this.appendXRefEntry(xrefInUseBlockBuilder, indirectObject.getReference(), this.stream.getLength());
                indirectObject.writeTo(this.stream, this.file);
            } else {
                this.appendXRefEntry(xrefBuilder, freeReference, index);
                xrefBuilder.append((CharSequence)xrefInUseBlockBuilder);
                xrefInUseBlockBuilder.setLength(0);
                freeReference = indirectObject.getReference();
            }
            ++index;
        }
        this.appendXRefEntry(xrefBuilder, freeReference, 0L);
        xrefBuilder.append((CharSequence)xrefInUseBlockBuilder);
        long startxref = this.stream.getLength();
        this.stream.write(xrefBuilder.toString());
        this.writeTrailer(startxref, xrefSize, null);
    }

    private StringBuilder appendXRefEntry(StringBuilder xrefBuilder, PdfReference reference, long offset) {
        String usage;
        switch (reference.getIndirectObject().getXrefEntry().getUsage()) {
            case Free: {
                usage = "f";
                break;
            }
            case InUse: {
                usage = "n";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return xrefBuilder.append(XRefOffsetFormatter.format(offset)).append(' ').append(XRefGenerationFormatter.format(reference.getGenerationNumber())).append(' ').append(usage).append(XRefEOLChunk);
    }

    private StringBuilder appendXRefSubsection(StringBuilder xrefBuilder, int firstObjectNumber, int entryCount, StringBuilder xrefSubBuilder) {
        return this.appendXRefSubsectionIndexer(xrefBuilder, firstObjectNumber, entryCount).append((CharSequence)xrefSubBuilder);
    }

    private StringBuilder appendXRefSubsectionIndexer(StringBuilder xrefBuilder, int firstObjectNumber, int entryCount) {
        return xrefBuilder.append(firstObjectNumber).append(' ').append(entryCount).append('\n');
    }

    private void writeTrailer(long startxref, int xrefSize, FileParser parser) {
        this.stream.write(TrailerChunk);
        PdfDictionary trailer = this.file.getTrailer();
        this.updateTrailer(trailer, this.stream);
        trailer.put(PdfName.Size, PdfInteger.get(xrefSize));
        if (parser == null) {
            trailer.remove(PdfName.Prev);
        } else {
            trailer.put(PdfName.Prev, PdfInteger.get((int)parser.retrieveXRefOffset()));
        }
        trailer.writeTo(this.stream, this.file);
        this.stream.write(Chunk.LineFeed);
        this.writeTail(startxref);
    }
}

