/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import java.util.Date;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDate;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.util.parsers.ParseException;
import org.pdfclown.util.parsers.PostScriptParser;

public class BaseParser
extends PostScriptParser {
    protected BaseParser(IInputStream stream) {
        super(stream);
    }

    protected BaseParser(byte[] data) {
        super(data);
    }

    @Override
    public boolean moveNext() {
        boolean moved;
        while (moved = super.moveNext()) {
            String literalToken;
            PostScriptParser.TokenTypeEnum tokenType = this.getTokenType();
            if (tokenType == PostScriptParser.TokenTypeEnum.Comment) continue;
            if (tokenType != PostScriptParser.TokenTypeEnum.Literal || !(literalToken = (String)this.getToken()).startsWith("D:")) break;
            try {
                this.setToken(PdfDate.toDate(literalToken));
            }
            catch (ParseException parseException) {}
            break;
        }
        return moved;
    }

    public PdfDataObject parsePdfObject() {
        switch (this.getTokenType()) {
            case Integer: {
                return PdfInteger.get((Integer)this.getToken());
            }
            case Name: {
                return new PdfName((String)this.getToken(), true);
            }
            case DictionaryBegin: {
                PdfDictionary dictionary = new PdfDictionary();
                dictionary.setUpdateable(false);
                while (true) {
                    this.moveNext();
                    if (this.getTokenType() == PostScriptParser.TokenTypeEnum.DictionaryEnd) break;
                    PdfName key = (PdfName)this.parsePdfObject();
                    this.moveNext();
                    PdfDirectObject value = (PdfDirectObject)this.parsePdfObject();
                    dictionary.put(key, value);
                }
                dictionary.setUpdateable(true);
                return dictionary;
            }
            case ArrayBegin: {
                PdfArray array = new PdfArray();
                array.setUpdateable(false);
                while (true) {
                    this.moveNext();
                    if (this.getTokenType() == PostScriptParser.TokenTypeEnum.ArrayEnd) break;
                    array.add((PdfDirectObject)this.parsePdfObject());
                }
                array.setUpdateable(true);
                return array;
            }
            case Literal: {
                if (this.getToken() instanceof Date) {
                    return PdfDate.get((Date)this.getToken());
                }
                return new PdfTextString(Encoding.Pdf.encode((String)this.getToken()));
            }
            case Hex: {
                return new PdfTextString((String)this.getToken(), PdfString.SerializationModeEnum.Hex);
            }
            case Real: {
                return PdfReal.get((Double)this.getToken());
            }
            case Boolean: {
                return PdfBoolean.get((Boolean)this.getToken());
            }
            case Null: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + this.getToken());
    }

    public PdfDataObject parsePdfObject(int offset) {
        this.moveNext(offset);
        return this.parsePdfObject();
    }
}

