/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.util.MapEntry;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF10)
public abstract class Tree<TKey extends PdfSimpleObject<?>, TValue extends PdfObjectWrapper<? extends PdfDataObject>>
extends PdfObjectWrapper<PdfDictionary>
implements Map<TKey, TValue> {
    private static final int TreeLowOrder = 5;
    private PdfName pairsKey;

    protected Tree(Document context) {
        super(context, new PdfDictionary());
        this.initialize();
    }

    protected Tree(PdfDirectObject baseObject) {
        super(baseObject);
        this.initialize();
    }

    public TKey getKey(TValue value) {
        for (Map.Entry<TKey, TValue> entry : this.entrySet()) {
            if (!((PdfObjectWrapper)entry.getValue()).equals(value)) continue;
            return (TKey)((PdfSimpleObject)entry.getKey());
        }
        return null;
    }

    @Override
    public void clear() {
        this.clear((PdfDictionary)this.getBaseDataObject());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotImplementedException();
    }

    @Override
    public Set<Map.Entry<TKey, TValue>> entrySet() {
        IFiller filler = new IFiller<Set<Map.Entry<TKey, TValue>>>(){
            private final Set<Map.Entry<TKey, TValue>> entrySet = new TreeSet();

            @Override
            public void add(PdfArray pairs, int offset) {
                PdfSimpleObject key = (PdfSimpleObject)pairs.get(offset);
                Object value = Tree.this.wrapValue(pairs.get(offset + 1));
                this.entrySet.add(new MapEntry(key, value));
            }

            @Override
            public Set<Map.Entry<TKey, TValue>> getCollection() {
                return this.entrySet;
            }
        };
        this.fill(filler, (PdfDictionary)this.getBaseDataObject());
        return (Set)filler.getCollection();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public TValue get(Object key) {
        PdfSimpleObject keyObject = (PdfSimpleObject)key;
        PdfDictionary parent = (PdfDictionary)this.getBaseDataObject();
        while (true) {
            PdfDictionary kid;
            int mid;
            int high;
            int low;
            Children children;
            if ((children = Children.get(parent, this.pairsKey)).isLeaf()) {
                low = 0;
                high = children.items.size() - children.info.itemSize;
                while (true) {
                    int comparison;
                    if (low > high) {
                        return null;
                    }
                    mid = (low + high) / 2;
                    if ((comparison = keyObject.compareTo(children.items.get(mid -= mid % 2))) < 0) {
                        high = mid - 2;
                        continue;
                    }
                    if (comparison <= 0) break;
                    low = mid + 2;
                }
                return this.wrapValue(children.items.get(mid + 1));
            }
            low = 0;
            high = children.items.size() - children.info.itemSize;
            while (true) {
                if (low > high) {
                    return null;
                }
                mid = (low + high) / 2;
                kid = (PdfDictionary)children.items.resolve(mid);
                PdfArray limits = (PdfArray)kid.resolve(PdfName.Limits);
                if (keyObject.compareTo(limits.get(0)) < 0) {
                    high = mid - 1;
                    continue;
                }
                if (keyObject.compareTo(limits.get(1)) <= 0) break;
                low = mid + 1;
            }
            parent = kid;
        }
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        PdfDictionary rootNode = (PdfDictionary)this.getBaseDataObject();
        PdfArray children = (PdfArray)rootNode.resolve(this.pairsKey);
        if (children == null) {
            children = (PdfArray)rootNode.resolve(PdfName.Kids);
        }
        return children == null || children.isEmpty();
    }

    @Override
    public Set<TKey> keySet() {
        IFiller filler = new IFiller<Set<TKey>>(){
            private final Set<TKey> keySet = new TreeSet();

            @Override
            public void add(PdfArray pairs, int offset) {
                this.keySet.add((PdfSimpleObject)pairs.get(offset));
            }

            @Override
            public Set<TKey> getCollection() {
                return this.keySet;
            }
        };
        this.fill(filler, (PdfDictionary)this.getBaseDataObject());
        return (Set)filler.getCollection();
    }

    @Override
    public TValue put(TKey key, TValue value) {
        PdfDictionary root = (PdfDictionary)this.getBaseDataObject();
        Children rootChildren = Children.get(root, this.pairsKey);
        if (rootChildren.isFull()) {
            PdfDictionary leaf = new PdfDictionary().swap(root);
            PdfArray rootChildrenObject = new PdfArray(this.getFile().register(leaf));
            root.put(PdfName.Kids, rootChildrenObject);
            this.splitFullNode(rootChildrenObject, 0, rootChildren.typeName);
        }
        return this.put(key, value, root);
    }

    @Override
    public void putAll(Map<? extends TKey, ? extends TValue> entries) {
        for (Map.Entry<TKey, TValue> entry : entries.entrySet()) {
            this.put((TKey)((PdfSimpleObject)entry.getKey()), (TValue)((PdfObjectWrapper)entry.getValue()));
        }
    }

    @Override
    public TValue remove(Object key) {
        PdfSimpleObject keyObject = (PdfSimpleObject)key;
        PdfDictionary node = (PdfDictionary)this.getBaseDataObject();
        Stack<PdfReference> nodeReferenceStack = new Stack<PdfReference>();
        while (true) {
            PdfDictionary kid;
            PdfReference kidReference;
            int mid;
            int high;
            int low;
            Children nodeChildren;
            if ((nodeChildren = Children.get(node, this.pairsKey)).isLeaf()) {
                low = 0;
                high = nodeChildren.items.size() - nodeChildren.info.itemSize;
                while (true) {
                    int comparison;
                    if (low > high) {
                        return null;
                    }
                    mid = (low + high) / 2;
                    if ((comparison = keyObject.compareTo(nodeChildren.items.get(mid -= mid % 2))) < 0) {
                        high = mid - 2;
                        continue;
                    }
                    if (comparison <= 0) break;
                    low = mid + 2;
                }
                TValue oldValue = this.wrapValue(nodeChildren.items.remove(mid + 1));
                nodeChildren.items.remove(mid);
                if (mid == 0 || mid == nodeChildren.items.size()) {
                    PdfReference nodeReference;
                    this.updateNodeLimits(nodeChildren);
                    PdfReference rootReference = (PdfReference)this.getBaseObject();
                    while (!nodeReferenceStack.isEmpty() && !(nodeReference = (PdfReference)nodeReferenceStack.pop()).equals(rootReference)) {
                        PdfArray parentChildren = (PdfArray)nodeReference.getParent();
                        int nodeIndex = parentChildren.indexOf(nodeReference);
                        if (nodeIndex != 0 && nodeIndex != parentChildren.size() - 1) break;
                        PdfDictionary parent = (PdfDictionary)parentChildren.getParent();
                        this.updateNodeLimits(parent, parentChildren, PdfName.Kids);
                    }
                }
                return oldValue;
            }
            low = 0;
            high = nodeChildren.items.size() - nodeChildren.info.itemSize;
            while (true) {
                if (low > high) {
                    return null;
                }
                mid = (low + high) / 2;
                kidReference = (PdfReference)nodeChildren.items.get(mid);
                kid = (PdfDictionary)kidReference.getDataObject();
                PdfArray limits = (PdfArray)kid.resolve(PdfName.Limits);
                if (keyObject.compareTo(limits.get(0)) < 0) {
                    high = mid - 1;
                    continue;
                }
                if (keyObject.compareTo(limits.get(1)) <= 0) break;
                low = mid + 1;
            }
            Children kidChildren = Children.get(kid, this.pairsKey);
            if (kidChildren.isUndersized()) {
                int endIndex;
                int index;
                PdfDictionary leftSibling = null;
                Children leftSiblingChildren = null;
                if (mid > 0) {
                    leftSibling = (PdfDictionary)nodeChildren.items.resolve(mid - 1);
                    leftSiblingChildren = Children.get(leftSibling, this.pairsKey);
                }
                PdfDictionary rightSibling = null;
                Children rightSiblingChildren = null;
                if (mid < nodeChildren.items.size() - 1) {
                    rightSibling = (PdfDictionary)nodeChildren.items.resolve(mid + 1);
                    rightSiblingChildren = Children.get(rightSibling, this.pairsKey);
                }
                if (leftSiblingChildren != null && !leftSiblingChildren.isUndersized()) {
                    index = 0;
                    endIndex = leftSiblingChildren.info.itemSize;
                    while (index < endIndex) {
                        kidChildren.items.add(0, leftSiblingChildren.items.remove(leftSiblingChildren.items.size() - 1));
                        ++index;
                    }
                    this.updateNodeLimits(leftSiblingChildren);
                } else if (rightSiblingChildren != null && !rightSiblingChildren.isUndersized()) {
                    index = 0;
                    endIndex = rightSiblingChildren.info.itemSize;
                    while (index < endIndex) {
                        kidChildren.items.add(rightSiblingChildren.items.remove(0));
                        ++index;
                    }
                    this.updateNodeLimits(rightSiblingChildren);
                } else {
                    if (leftSibling != null) {
                        index = leftSiblingChildren.items.size();
                        while (index-- > 0) {
                            kidChildren.items.add(0, leftSiblingChildren.items.remove(index));
                        }
                        nodeChildren.items.remove(mid - 1);
                        leftSibling.getReference().delete();
                    } else if (rightSibling != null) {
                        index = rightSiblingChildren.items.size();
                        while (index-- > 0) {
                            kidChildren.items.add(rightSiblingChildren.items.remove(0));
                        }
                        nodeChildren.items.remove(mid + 1);
                        rightSibling.getReference().delete();
                    }
                    if (nodeChildren.items.size() == 1) {
                        nodeChildren.items.remove(0);
                        index = kidChildren.items.size();
                        while (index-- > 0) {
                            nodeChildren.items.add(kidChildren.items.remove(0));
                        }
                        kid.getReference().delete();
                        kid = node;
                        kidReference = kid.getReference();
                        kidChildren = nodeChildren;
                    }
                }
                this.updateNodeLimits(kidChildren);
            }
            nodeReferenceStack.push(kidReference);
            node = kid;
        }
    }

    @Override
    public int size() {
        return this.size((PdfDictionary)this.getBaseDataObject());
    }

    @Override
    public Collection<TValue> values() {
        IFiller filler = new IFiller<Collection<TValue>>(){
            private final Collection<TValue> values = new ArrayList();

            @Override
            public void add(PdfArray pairs, int offset) {
                this.values.add(Tree.this.wrapValue(pairs.get(offset + 1)));
            }

            @Override
            public Collection<TValue> getCollection() {
                return this.values;
            }
        };
        this.fill(filler, (PdfDictionary)this.getBaseDataObject());
        return filler.getCollection();
    }

    protected abstract PdfName getPairsKey();

    protected abstract TValue wrapValue(PdfDirectObject var1);

    private void clear(PdfDictionary node) {
        Children children = Children.get(node, this.pairsKey);
        if (!children.isLeaf()) {
            for (PdfDirectObject child : children.items) {
                this.clear((PdfDictionary)child.resolve());
                this.getFile().unregister((PdfReference)child);
            }
            node.put(this.pairsKey, node.remove(children.typeName));
        }
        children.items.clear();
        node.remove(PdfName.Limits);
    }

    private <TCollection extends Collection<?>> void fill(IFiller<TCollection> filler, PdfDictionary node) {
        PdfArray kidsObject = (PdfArray)node.resolve(PdfName.Kids);
        if (kidsObject == null) {
            PdfArray pairsObject = (PdfArray)node.resolve(this.pairsKey);
            int index = 0;
            int length = pairsObject.size();
            while (index < length) {
                filler.add(pairsObject, index);
                index += 2;
            }
        } else {
            for (PdfDirectObject kidObject : kidsObject) {
                this.fill(filler, (PdfDictionary)kidObject.resolve());
            }
        }
    }

    private void initialize() {
        this.pairsKey = this.getPairsKey();
        PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
        if (baseDataObject.isEmpty()) {
            baseDataObject.setUpdateable(false);
            baseDataObject.put(this.pairsKey, new PdfArray());
            baseDataObject.setUpdateable(true);
        }
    }

    private TValue put(TKey key, TValue value, PdfDictionary node) {
        TValue oldValue;
        Children children = Children.get(node, this.pairsKey);
        if (children.isLeaf()) {
            block11: {
                int mid;
                int childrenSize = children.items.size();
                int low = 0;
                int high = childrenSize - children.info.itemSize;
                while (true) {
                    if (low > high) {
                        oldValue = null;
                        children.items.add(low, (PdfDirectObject)key);
                        children.items.add(++low, ((PdfObjectWrapper)value).getBaseObject());
                        break block11;
                    }
                    mid = (low + high) / 2;
                    if ((mid -= mid % 2) >= childrenSize) {
                        oldValue = null;
                        children.items.add((PdfDirectObject)key);
                        children.items.add(((PdfObjectWrapper)value).getBaseObject());
                        break block11;
                    }
                    int comparison = ((PdfDirectObject)key).compareTo(children.items.get(mid));
                    if (comparison < 0) {
                        high = mid - 2;
                        continue;
                    }
                    if (comparison <= 0) break;
                    low = mid + 2;
                }
                oldValue = this.wrapValue(children.items.get(mid + 1));
                children.items.set(mid, (PdfDirectObject)key);
                children.items.set(++mid, ((PdfObjectWrapper)value).getBaseObject());
            }
            this.updateNodeLimits(children);
        } else {
            PdfDictionary kid;
            PdfReference kidReference;
            int mid;
            boolean matched;
            int low = 0;
            int high = children.items.size() - children.info.itemSize;
            do {
                matched = false;
                mid = (low + high) / 2;
                kidReference = (PdfReference)children.items.get(mid);
                kid = (PdfDictionary)kidReference.getDataObject();
                PdfArray limits = (PdfArray)kid.resolve(PdfName.Limits);
                if (((PdfDirectObject)key).compareTo(limits.get(0)) < 0) {
                    high = mid - 1;
                    continue;
                }
                if (((PdfDirectObject)key).compareTo(limits.get(1)) > 0) {
                    low = mid + 1;
                    continue;
                }
                matched = true;
            } while (!matched && low <= high);
            Children kidChildren = Children.get(kid, this.pairsKey);
            if (kidChildren.isFull()) {
                this.splitFullNode(children.items, mid, kidChildren.typeName);
                if (((PdfDirectObject)key).compareTo(((PdfArray)kid.resolve(PdfName.Limits)).get(0)) < 0) {
                    kidReference = (PdfReference)children.items.get(mid);
                    kid = (PdfDictionary)kidReference.getDataObject();
                }
            }
            oldValue = this.put(key, value, kid);
            this.updateNodeLimits(children);
        }
        return oldValue;
    }

    private int size(PdfDictionary node) {
        PdfArray children = (PdfArray)node.resolve(this.pairsKey);
        if (children != null) {
            return children.size() / 2;
        }
        children = (PdfArray)node.resolve(PdfName.Kids);
        int size = 0;
        for (PdfDirectObject child : children) {
            size += this.size((PdfDictionary)child.resolve());
        }
        return size;
    }

    private void splitFullNode(PdfArray nodes, int fullNodeIndex, PdfName childrenTypeName) {
        PdfDictionary fullNode = (PdfDictionary)nodes.resolve(fullNodeIndex);
        PdfArray fullNodeChildren = (PdfArray)fullNode.resolve(childrenTypeName);
        PdfDictionary newNode = new PdfDictionary();
        PdfArray newNodeChildren = new PdfArray();
        newNode.put(childrenTypeName, newNodeChildren);
        nodes.add(fullNodeIndex, this.getFile().register(newNode));
        int index = 0;
        int length = Children.Info.get((PdfName)childrenTypeName).minSize;
        while (index < length) {
            newNodeChildren.add(fullNodeChildren.remove(0));
            ++index;
        }
        this.updateNodeLimits(newNode, newNodeChildren, childrenTypeName);
        this.updateNodeLimits(fullNode, fullNodeChildren, childrenTypeName);
    }

    private void updateNodeLimits(Children children) {
        this.updateNodeLimits(children.parent, children.items, children.typeName);
    }

    private void updateNodeLimits(PdfDictionary node, PdfArray children, PdfName childrenTypeName) {
        PdfDirectObject highLimit;
        PdfDirectObject lowLimit;
        if (childrenTypeName.equals(PdfName.Kids)) {
            if (node == this.getBaseDataObject()) {
                return;
            }
            lowLimit = ((PdfArray)((PdfDictionary)children.resolve(0)).resolve(PdfName.Limits)).get(0);
            highLimit = ((PdfArray)((PdfDictionary)children.resolve(children.size() - 1)).resolve(PdfName.Limits)).get(1);
        } else if (childrenTypeName.equals(this.pairsKey)) {
            lowLimit = children.get(0);
            highLimit = children.get(children.size() - 2);
        } else {
            throw new UnsupportedOperationException(childrenTypeName + " is NOT a supported child type.");
        }
        PdfArray limits = (PdfArray)node.get(PdfName.Limits);
        if (limits != null) {
            limits.set(0, lowLimit);
            limits.set(1, highLimit);
        } else {
            node.put(PdfName.Limits, new PdfArray(lowLimit, highLimit));
        }
    }

    private static final class Children {
        public final PdfArray items;
        public final Info info;
        public final PdfDictionary parent;
        public final PdfName typeName;

        public static Children get(PdfDictionary node, PdfName pairsKey) {
            PdfName childrenTypeName;
            if (node.containsKey(PdfName.Kids)) {
                childrenTypeName = PdfName.Kids;
            } else if (node.containsKey(pairsKey)) {
                childrenTypeName = pairsKey;
            } else {
                throw new RuntimeException("Malformed tree node.");
            }
            PdfArray children = (PdfArray)node.resolve(childrenTypeName);
            return new Children(node, children, childrenTypeName);
        }

        private Children(PdfDictionary parent, PdfArray items, PdfName typeName) {
            this.parent = parent;
            this.items = items;
            this.typeName = typeName;
            this.info = Info.get(typeName);
        }

        public boolean isFull() {
            return this.items.size() >= this.info.maxSize;
        }

        public boolean isLeaf() {
            return !this.typeName.equals(PdfName.Kids);
        }

        public boolean isOversized() {
            return this.items.size() > this.info.maxSize;
        }

        public boolean isUndersized() {
            return this.items.size() < this.info.minSize;
        }

        public boolean isValid() {
            return !this.isUndersized() && !this.isOversized();
        }

        private static final class Info {
            private static final Info KidsInfo = new Info(1, 5);
            private static final Info PairsInfo = new Info(2, 5);
            int itemSize;
            int maxSize;
            int minSize;

            private static Info get(PdfName typeName) {
                return typeName.equals(PdfName.Kids) ? KidsInfo : PairsInfo;
            }

            public Info(int itemSize, int lowOrder) {
                this.itemSize = itemSize;
                this.minSize = itemSize * lowOrder;
                this.maxSize = this.minSize * 2;
            }
        }
    }

    private static interface IFiller<TCollection extends Collection<?>> {
        public void add(PdfArray var1, int var2);

        public TCollection getCollection();
    }
}

