/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Collection;
import org.pdfclown.PDF;
import org.pdfclown.Version;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interchange.metadata.Metadata;
import org.pdfclown.files.File;
import org.pdfclown.objects.IPdfObjectWrapper;
import org.pdfclown.objects.NameTree;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.PdfString;
import org.pdfclown.util.NotImplementedException;

public abstract class PdfObjectWrapper<TDataObject extends PdfDataObject>
implements Cloneable,
IPdfObjectWrapper {
    private PdfDirectObject baseObject;

    public static PdfDirectObject getBaseObject(PdfObjectWrapper<?> wrapper) {
        return wrapper != null ? wrapper.getBaseObject() : null;
    }

    protected PdfObjectWrapper() {
    }

    protected PdfObjectWrapper(PdfDirectObject baseObject) {
        this.setBaseObject(baseObject);
    }

    protected PdfObjectWrapper(Document context, TDataObject baseDataObject) {
        this(context.getFile(), baseDataObject);
    }

    protected PdfObjectWrapper(File context, TDataObject baseDataObject) {
        this(context.register((PdfDataObject)baseDataObject));
    }

    public Object clone(Document context) {
        PdfObjectWrapper clone;
        try {
            clone = (PdfObjectWrapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.setBaseObject((PdfDirectObject)this.getBaseObject().clone(context.getFile()));
        return clone;
    }

    public boolean delete() {
        if (this.baseObject instanceof PdfReference) {
            ((PdfReference)this.baseObject).delete();
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && ((PdfObjectWrapper)obj).baseObject.equals(this.baseObject);
    }

    public boolean exists() {
        return !((PdfObject)this.getBaseDataObject()).isVirtual();
    }

    public TDataObject getBaseDataObject() {
        return (TDataObject)PdfObject.resolve(this.baseObject);
    }

    public PdfIndirectObject getContainer() {
        return this.baseObject.getContainer();
    }

    public PdfIndirectObject getDataContainer() {
        return this.baseObject.getDataContainer();
    }

    public Document getDocument() {
        File file = this.getFile();
        return file != null ? file.getDocument() : null;
    }

    public File getFile() {
        return this.baseObject.getFile();
    }

    public Metadata getMetadata() {
        PdfDictionary dictionary = this.getDictionary();
        if (dictionary == null) {
            return null;
        }
        return new Metadata(dictionary.get(PdfName.Metadata, PdfStream.class, false));
    }

    public void setMetadata(Metadata value) {
        PdfDictionary dictionary = this.getDictionary();
        if (dictionary == null) {
            throw new UnsupportedOperationException("Metadata can be attached only to PdfDictionary/PdfStream base data objects.");
        }
        dictionary.put(PdfName.Metadata, PdfObjectWrapper.getBaseObject(value));
    }

    @Override
    public PdfDirectObject getBaseObject() {
        return this.baseObject;
    }

    protected void checkCompatibility(Object feature) {
        Version featureVersion;
        Document.Configuration.CompatibilityModeEnum compatibilityMode = this.getDocument().getConfiguration().getCompatibilityMode();
        if (compatibilityMode == Document.Configuration.CompatibilityModeEnum.Passthrough) {
            return;
        }
        if (feature instanceof Collection) {
            for (Object featureItem : (Collection)((Object)feature)) {
                this.checkCompatibility(featureItem);
            }
            return;
        }
        if (feature instanceof VersionEnum) {
            featureVersion = ((VersionEnum)((Object)feature)).getVersion();
        } else {
            PDF annotation;
            if (feature instanceof String) {
                BeanInfo classInfo;
                try {
                    classInfo = Introspector.getBeanInfo(this.getClass());
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
                PropertyDescriptor[] propertyDescriptorArray = classInfo.getPropertyDescriptors();
                int n = propertyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor property = propertyDescriptorArray[n2];
                    if (feature.equals(property.getName())) {
                        feature = property.getReadMethod();
                        break;
                    }
                    ++n2;
                }
            } else if (feature instanceof Enum) {
                try {
                    feature = feature.getClass().getField(((Enum)((Object)feature)).name());
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(feature instanceof AnnotatedElement)) {
                throw new IllegalArgumentException("Feature type '" + feature.getClass().getName() + "' not supported.");
            }
            while ((annotation = ((AnnotatedElement)feature).getAnnotation(PDF.class)) == null) {
                if (feature instanceof Member) {
                    feature = ((Member)((Object)feature)).getDeclaringClass();
                    continue;
                }
                if (feature instanceof Class) {
                    Class<?> containerClass = feature.getDeclaringClass();
                    feature = containerClass != null ? containerClass : feature.getPackage();
                    continue;
                }
                return;
            }
            featureVersion = annotation.value().getVersion();
        }
        if (this.getDocument().getVersion().compareTo(featureVersion) >= 0) {
            return;
        }
        switch (compatibilityMode) {
            case Loose: {
                this.getDocument().setVersion(featureVersion);
                break;
            }
            case Strict: {
                throw new RuntimeException("Incompatible feature (version " + featureVersion + " was required against document version " + this.getDocument().getVersion());
            }
            default: {
                throw new NotImplementedException("Unhandled compatibility mode: " + compatibilityMode.name());
            }
        }
    }

    protected PdfString retrieveName() {
        return this.retrieveNameHelper((NameTree)this.getDocument().getNames().get((Class)this.getClass()));
    }

    protected PdfDirectObject retrieveNamedBaseObject() {
        PdfString name = this.retrieveName();
        return name != null ? name : this.getBaseObject();
    }

    protected void setBaseObject(PdfDirectObject value) {
        this.baseObject = value;
    }

    private PdfDictionary getDictionary() {
        TDataObject baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return (PdfDictionary)baseDataObject;
        }
        if (baseDataObject instanceof PdfStream) {
            return ((PdfStream)baseDataObject).getHeader();
        }
        return null;
    }

    private <T extends PdfObjectWrapper<TDataObject>> PdfString retrieveNameHelper(NameTree<T> names) {
        return names != null ? (PdfString)names.getKey(this) : null;
    }
}

