/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IPdfIndirectObject;
import org.pdfclown.objects.IVisitable;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfReference;

public abstract class PdfObject
implements Cloneable,
IVisitable {
    public static final PdfObject clone(PdfObject object, File context) {
        return object == null ? null : object.clone(context);
    }

    public static PdfDataObject resolve(PdfObject object) {
        return object == null ? null : object.resolve();
    }

    public static PdfDirectObject unresolve(PdfDataObject object) {
        return object == null ? null : object.unresolve();
    }

    protected PdfObject() {
    }

    public PdfObject clone(File context) {
        return this.accept(context.getCloner(), null);
    }

    public PdfIndirectObject getContainer() {
        PdfObject parent = this.getParent();
        return parent != null ? parent.getContainer() : null;
    }

    public PdfIndirectObject getDataContainer() {
        PdfIndirectObject indirectObject = this.getIndirectObject();
        return indirectObject != null ? indirectObject : this.getContainer();
    }

    public File getFile() {
        PdfIndirectObject dataContainer = this.getDataContainer();
        return dataContainer != null ? dataContainer.getFile() : null;
    }

    public PdfIndirectObject getIndirectObject() {
        PdfObject parent = this.getParent();
        return parent instanceof PdfIndirectObject ? (PdfIndirectObject)parent : null;
    }

    public abstract PdfObject getParent();

    public PdfReference getReference() {
        PdfIndirectObject indirectObject = this.getIndirectObject();
        return indirectObject != null ? indirectObject.getReference() : null;
    }

    public abstract boolean isUpdateable();

    public abstract boolean isUpdated();

    public PdfDataObject resolve() {
        return this instanceof IPdfIndirectObject ? ((IPdfIndirectObject)((Object)this)).getDataObject() : (PdfDataObject)this;
    }

    public abstract void setUpdateable(boolean var1);

    public abstract PdfObject swap(PdfObject var1);

    public PdfDirectObject unresolve() {
        PdfReference reference = this.getReference();
        return reference != null ? reference : (PdfDirectObject)this;
    }

    public abstract void writeTo(IOutputStream var1, File var2);

    protected final Object clone() {
        PdfObject clone;
        try {
            clone = (PdfObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.setParent(null);
        return clone;
    }

    protected abstract boolean isVirtual();

    protected abstract void setUpdated(boolean var1);

    protected abstract void setVirtual(boolean var1);

    protected final void update() {
        if (!this.isUpdateable() || this.isUpdated()) {
            return;
        }
        this.setUpdated(true);
        this.setVirtual(false);
        if (this.getParent() != null) {
            this.getParent().update();
        }
    }

    final void exclude(PdfDataObject object) {
        if (object != null) {
            object.setParent(null);
        }
    }

    final PdfDataObject include(PdfDataObject object) {
        if (object != null) {
            if (object.getParent() != null) {
                object = (PdfDataObject)object.clone();
            }
            object.setParent(this);
        }
        return object;
    }

    abstract void setParent(PdfObject var1);
}

