/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IPdfIndirectObject;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.tokens.FileParser;
import org.pdfclown.tokens.ObjectStream;
import org.pdfclown.tokens.XRefEntry;

public class PdfIndirectObject
extends PdfObject
implements IPdfIndirectObject {
    private static final byte[] BeginIndirectObjectChunk = Encoding.Pdf.encode(" obj\n");
    private static final byte[] EndIndirectObjectChunk = Encoding.Pdf.encode("\nendobj\n");
    private PdfDataObject dataObject;
    private File file;
    private boolean original;
    private final PdfReference reference;
    private final XRefEntry xrefEntry;
    private boolean updated;
    private boolean updateable = true;
    private boolean virtual;

    public PdfIndirectObject(File file, PdfDataObject dataObject, XRefEntry xrefEntry) {
        this.file = file;
        this.dataObject = this.include(dataObject);
        this.xrefEntry = xrefEntry;
        this.original = xrefEntry.getOffset() >= 0;
        this.reference = new PdfReference(this);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void compress(ObjectStream objectStream) {
        this.uncompress();
        if (objectStream != null) {
            objectStream.put(this.xrefEntry.getNumber(), this.getDataObject());
            this.xrefEntry.setUsage(XRefEntry.UsageEnum.InUseCompressed);
            this.xrefEntry.setStreamNumber(objectStream.getReference().getObjectNumber());
            this.xrefEntry.setOffset(-1);
        }
    }

    @Override
    public PdfIndirectObject getContainer() {
        return this;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public PdfObject getParent() {
        return null;
    }

    public XRefEntry getXrefEntry() {
        return this.xrefEntry;
    }

    public int hashCode() {
        return this.reference.getId().hashCode() ^ this.file.hashCode();
    }

    public boolean isCompressed() {
        return this.xrefEntry.getUsage() == XRefEntry.UsageEnum.InUseCompressed;
    }

    public boolean isInUse() {
        return this.xrefEntry.getUsage() != XRefEntry.UsageEnum.Free;
    }

    public boolean isOriginal() {
        return this.original;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public void setUpdateable(boolean value) {
        this.updateable = value;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.reference.getId()).append(" obj").append('\n');
        buffer.append(this.getDataObject());
        return buffer.toString();
    }

    @Override
    public PdfIndirectObject swap(PdfObject other) {
        PdfIndirectObject otherObject = (PdfIndirectObject)other;
        PdfDataObject otherDataObject = otherObject.dataObject;
        otherObject.setDataObject(this.dataObject);
        this.setDataObject(otherDataObject);
        return this;
    }

    public void uncompress() {
        if (!this.isCompressed()) {
            return;
        }
        ObjectStream oldObjectStream = (ObjectStream)this.file.getIndirectObjects().get(this.xrefEntry.getStreamNumber()).getDataObject();
        oldObjectStream.remove(this.xrefEntry.getNumber());
        this.xrefEntry.setUsage(XRefEntry.UsageEnum.InUse);
        this.xrefEntry.setStreamNumber(-1);
        this.xrefEntry.setOffset(-1);
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        stream.write(this.reference.getId());
        stream.write(BeginIndirectObjectChunk);
        this.getDataObject().writeTo(stream, context);
        stream.write(EndIndirectObjectChunk);
    }

    @Override
    public PdfIndirectObject clone(File context) {
        return (PdfIndirectObject)super.clone(context);
    }

    @Override
    public void delete() {
        if (this.file == null) {
            return;
        }
        this.file.getIndirectObjects().remove(this.xrefEntry.getNumber());
    }

    @Override
    public PdfDataObject getDataObject() {
        if (this.dataObject == null) {
            switch (this.xrefEntry.getUsage()) {
                case Free: {
                    break;
                }
                case InUse: {
                    FileParser parser = this.file.getReader().getParser();
                    parser.seek(this.xrefEntry.getOffset());
                    this.dataObject = this.include(parser.parsePdfObject(4));
                    break;
                }
                case InUseCompressed: {
                    ObjectStream objectStream = (ObjectStream)this.file.getIndirectObjects().get(this.xrefEntry.getStreamNumber()).getDataObject();
                    this.dataObject = this.include(objectStream.get(this.xrefEntry.getNumber()));
                }
            }
        }
        return this.dataObject;
    }

    @Override
    public PdfIndirectObject getIndirectObject() {
        return this;
    }

    @Override
    public PdfReference getReference() {
        return this.reference;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    @Override
    public void setDataObject(PdfDataObject value) {
        if (this.xrefEntry.getGeneration() == 65535) {
            throw new RuntimeException("Unreusable entry.");
        }
        this.exclude(this.dataObject);
        this.dataObject = this.include(value);
        this.xrefEntry.setUsage(XRefEntry.UsageEnum.InUse);
        this.update();
    }

    @Override
    protected boolean isVirtual() {
        return this.virtual;
    }

    @Override
    protected void setUpdated(boolean value) {
        if (value && this.original) {
            this.file.getIndirectObjects().update(this);
        }
        this.updated = value;
    }

    @Override
    protected void setVirtual(boolean value) {
        if (this.virtual && !value) {
            this.file.getIndirectObjects().addVirtual(this);
            this.virtual = false;
            this.getReference().update();
        } else {
            this.virtual = value;
        }
        this.dataObject.setVirtual(this.virtual);
    }

    public void dropFile() {
        this.uncompress();
        this.file = null;
    }

    public void dropOriginal() {
        this.original = false;
    }

    @Override
    void setParent(PdfObject value) {
    }
}

