/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.Visitor;
import org.pdfclown.tokens.ObjectStream;
import org.pdfclown.tokens.XRefStream;

public class Cloner
extends Visitor {
    private static final Filter NullFilter = new Filter("Default");
    private static List<Filter> commonFilters = new ArrayList<Filter>();
    private File context;
    private final List<Filter> filters = new ArrayList<Filter>(commonFilters);

    static {
        commonFilters.add(new Filter("Page"){

            @Override
            public void afterClone(Cloner cloner, PdfObject clone, PdfObject source) {
                PdfDictionary cloneDictionary = (PdfDictionary)clone;
                PdfDictionary sourceDictionary = (PdfDictionary)source;
                for (PdfName key : Page.InheritableAttributeKeys) {
                    PdfDirectObject sourceValue;
                    if (sourceDictionary.containsKey(key) || (sourceValue = Page.getInheritableAttribute(sourceDictionary, key)) == null) continue;
                    cloneDictionary.put(key, (PdfDirectObject)sourceValue.accept(cloner, null));
                }
            }

            @Override
            public boolean beforeClone(Cloner cloner, PdfDictionary parent, PdfName key, PdfDirectObject value) {
                return !PdfName.Parent.equals(key);
            }

            @Override
            public boolean matches(Cloner cloner, PdfObject object) {
                return object instanceof PdfDictionary && PdfName.Page.equals(((PdfDictionary)object).get(PdfName.Type));
            }
        });
        commonFilters.add(new Filter("Annots"){

            @Override
            public void afterClone(Cloner cloner, PdfArray parent, int index, PdfDirectObject item) {
                PdfDictionary annotation = (PdfDictionary)item.resolve();
                if (annotation.containsKey(PdfName.FT)) {
                    cloner.context.getDocument().getForm().getFields().add(Field.wrap(annotation.getReference()));
                }
            }

            @Override
            public boolean matches(Cloner cloner, PdfObject object) {
                PdfDataObject arrayItem;
                PdfArray array;
                if (object instanceof PdfArray && !(array = (PdfArray)object).isEmpty() && (arrayItem = array.resolve(0)) instanceof PdfDictionary) {
                    PdfDictionary arrayItemDictionary = (PdfDictionary)arrayItem;
                    return arrayItemDictionary.containsKey(PdfName.Subtype) && arrayItemDictionary.containsKey(PdfName.Rect);
                }
                return false;
            }
        });
    }

    public Cloner(File context) {
        this.setContext(context);
    }

    public File getContext() {
        return this.context;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setContext(File value) {
        if (value == null) {
            throw new IllegalArgumentException("value required");
        }
        this.context = value;
    }

    @Override
    public PdfObject visit(ObjectStream object, Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PdfObject visit(PdfArray object, Object data) {
        Filter cloneFilter = this.matchFilter(object);
        PdfArray clone = (PdfArray)object.clone();
        clone.items = new ArrayList();
        ArrayList<PdfDirectObject> sourceItems = object.items;
        int index = 0;
        int length = sourceItems.size();
        while (index < length) {
            PdfDirectObject sourceItem = (PdfDirectObject)sourceItems.get(index);
            if (cloneFilter.beforeClone(this, clone, index, sourceItem)) {
                PdfDirectObject cloneItem = (PdfDirectObject)(sourceItem != null ? sourceItem.accept(this, null) : null);
                clone.add(cloneItem);
                cloneFilter.afterClone(this, clone, index, cloneItem);
            }
            ++index;
        }
        cloneFilter.afterClone(this, clone, object);
        return clone;
    }

    @Override
    public PdfObject visit(PdfDictionary object, Object data) {
        Filter cloneFilter = this.matchFilter(object);
        PdfDictionary clone = (PdfDictionary)object.clone();
        clone.entries = new HashMap<PdfName, PdfDirectObject>();
        for (Map.Entry<PdfName, PdfDirectObject> entry : object.entries.entrySet()) {
            PdfDirectObject sourceValue = entry.getValue();
            if (!cloneFilter.beforeClone(this, clone, entry.getKey(), sourceValue)) continue;
            PdfDirectObject cloneValue = (PdfDirectObject)(sourceValue != null ? sourceValue.accept(this, null) : null);
            clone.put(entry.getKey(), cloneValue);
            cloneFilter.afterClone(this, clone, entry.getKey(), cloneValue);
        }
        cloneFilter.afterClone(this, clone, object);
        return clone;
    }

    @Override
    public PdfObject visit(PdfIndirectObject object, Object data) {
        return this.context.getIndirectObjects().addExternal(object, this);
    }

    @Override
    public PdfObject visit(PdfReference object, Object data) {
        return this.context == object.getFile() ? (PdfReference)object.clone() : this.visit(object.getIndirectObject(), data).getReference();
    }

    @Override
    public PdfObject visit(PdfStream object, Object data) {
        PdfStream clone = (PdfStream)object.clone();
        clone.header = (PdfDictionary)this.visit(object.header, data);
        clone.body = object.body.clone();
        return clone;
    }

    @Override
    public PdfObject visit(XRefStream object, Object data) {
        throw new UnsupportedOperationException();
    }

    private Filter matchFilter(PdfObject object) {
        Filter cloneFilter = NullFilter;
        for (Filter filter : this.filters) {
            if (!filter.matches(this, object)) continue;
            cloneFilter = filter;
            break;
        }
        return cloneFilter;
    }

    public static class Filter {
        private final String name;

        public Filter(String name) {
            this.name = name;
        }

        public void afterClone(Cloner cloner, PdfObject clone, PdfObject source) {
        }

        public void afterClone(Cloner cloner, PdfDictionary parent, PdfName key, PdfDirectObject value) {
        }

        public void afterClone(Cloner cloner, PdfArray parent, int index, PdfDirectObject item) {
        }

        public boolean beforeClone(Cloner cloner, PdfDictionary parent, PdfName key, PdfDirectObject value) {
            return true;
        }

        public boolean beforeClone(Cloner cloner, PdfArray parent, int index, PdfDirectObject item) {
            return true;
        }

        public String getName() {
            return this.name;
        }

        public boolean matches(Cloner cloner, PdfObject source) {
            return true;
        }
    }
}

