/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.multimedia;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfString;
import org.pdfclown.util.math.Interval;
import org.pdfclown.util.metadata.IVersion;
import org.pdfclown.util.metadata.VersionUtils;

@PDF(value=VersionEnum.PDF15)
public final class SoftwareIdentifier
extends PdfObjectWrapper<PdfDictionary> {
    public static SoftwareIdentifier wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new SoftwareIdentifier(baseObject) : null;
    }

    public SoftwareIdentifier(Document context) {
        super(context, new PdfDictionary());
    }

    private SoftwareIdentifier(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public SoftwareIdentifier clone(Document context) {
        return (SoftwareIdentifier)super.clone(context);
    }

    public List<String> getOSes() {
        ArrayList<String> oses = new ArrayList<String>();
        PdfArray osesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.OS);
        if (osesObject != null) {
            for (PdfDirectObject osObject : osesObject) {
                oses.add(((PdfString)osObject).getStringValue());
            }
        }
        return oses;
    }

    public URI getURI() {
        try {
            PdfString uriObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.U);
            return uriObject != null ? new URI(uriObject.getStringValue()) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("URI instantiation failed.", e);
        }
    }

    public Interval<Version> getVersion() {
        PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
        return new Interval<Version>(new Version(baseDataObject.get(PdfName.L)), new Version(baseDataObject.get(PdfName.H)), (Boolean)PdfBoolean.getValue(baseDataObject.get(PdfName.LI), true), (Boolean)PdfBoolean.getValue(baseDataObject.get(PdfName.HI), true));
    }

    public static final class Version
    extends PdfObjectWrapper<PdfArray>
    implements IVersion {
        public Version(Integer ... numbers) {
            super(new PdfArray());
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            Integer[] integerArray = numbers;
            int n = numbers.length;
            int n2 = 0;
            while (n2 < n) {
                Integer number = integerArray[n2];
                baseDataObject.add(new PdfInteger(number));
                ++n2;
            }
        }

        private Version(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Version clone(Document context) {
            return (Version)super.clone(context);
        }

        @Override
        public int compareTo(IVersion value) {
            return VersionUtils.compareTo(this, value);
        }

        @Override
        public List<Integer> getNumbers() {
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            for (PdfDirectObject numberObject : (PdfArray)this.getBaseDataObject()) {
                numbers.add(((PdfInteger)numberObject).getValue());
            }
            return numbers;
        }

        public String toString() {
            return VersionUtils.toString(this);
        }
    }
}

