/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.multimedia;

import java.util.HashMap;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.multimedia.MediaPlayers;
import org.pdfclown.documents.multimedia.Timespan;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF15)
public final class MediaPlayParameters
extends PdfObjectWrapper<PdfDictionary> {
    public MediaPlayParameters(Document context) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.MediaPlayParams}));
    }

    MediaPlayParameters(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public MediaPlayParameters clone(Document context) {
        return (MediaPlayParameters)super.clone(context);
    }

    public MediaPlayers getPlayers() {
        return MediaPlayers.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.PL, PdfDictionary.class));
    }

    public Viability getPreferences() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.BE, PdfDictionary.class));
    }

    public Viability getRequirements() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.MH, PdfDictionary.class));
    }

    public void setPlayers(MediaPlayers value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PL, PdfObjectWrapper.getBaseObject(value));
    }

    public void setPreferences(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BE, PdfObjectWrapper.getBaseObject(value));
    }

    public void setRequirements(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MH, PdfObjectWrapper.getBaseObject(value));
    }

    public static class Viability
    extends PdfObjectWrapper<PdfDictionary> {
        private Viability(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Viability clone(Document context) {
            return (Viability)super.clone(context);
        }

        public double getDuration() {
            PdfDirectObject durationObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
            return durationObject != null ? new Duration(durationObject).getValue() : Double.NEGATIVE_INFINITY;
        }

        public FitModeEnum getFitMode() {
            return FitModeEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.F));
        }

        public double getRepeatCount() {
            return (Double)PdfReal.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.RC), 1.0);
        }

        public int getVolume() {
            return (Integer)PdfInteger.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.V), 100);
        }

        public boolean isAutoplay() {
            return (Boolean)PdfBoolean.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.A), true);
        }

        public boolean isPlayerSpecificControl() {
            return (Boolean)PdfBoolean.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.C), false);
        }

        public void setAutoplay(boolean value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, PdfBoolean.get(value));
        }

        public void setDuration(double value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, new Duration(value).getBaseObject());
        }

        public void setFitMode(FitModeEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, value != null ? value.getCode() : null);
        }

        public void setPlayerSpecificControl(boolean value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.C, PdfBoolean.get(value));
        }

        public void setRepeatCount(double value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RC, PdfReal.get(value));
        }

        public void setVolume(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > 100) {
                value = 100;
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, PdfInteger.get(value));
        }

        private static class Duration
        extends PdfObjectWrapper<PdfDictionary> {
            private Duration(double value) {
                super(new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.MediaDuration}));
                this.setValue(value);
            }

            private Duration(PdfDirectObject baseObject) {
                super(baseObject);
            }

            @Override
            public Duration clone(Document context) {
                return (Duration)super.clone(context);
            }

            public double getValue() {
                PdfName durationSubtype = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S);
                if (PdfName.I.equals(durationSubtype)) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (PdfName.F.equals(durationSubtype)) {
                    return Double.POSITIVE_INFINITY;
                }
                if (PdfName.T.equals(durationSubtype)) {
                    return new Timespan(((PdfDictionary)this.getBaseDataObject()).get(PdfName.T)).getTime();
                }
                throw new UnsupportedOperationException("Duration subtype '" + durationSubtype + "'");
            }

            public void setValue(double value) {
                if (value == Double.NEGATIVE_INFINITY) {
                    ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, PdfName.I);
                    ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.T);
                } else if (value == Double.POSITIVE_INFINITY) {
                    ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, PdfName.F);
                    ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.T);
                } else {
                    ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, PdfName.T);
                    new Timespan(((PdfDictionary)this.getBaseDataObject()).get(PdfName.T, PdfDictionary.class)).setTime(value);
                }
            }
        }

        public static enum FitModeEnum {
            Meet(new PdfInteger(0)),
            Slice(new PdfInteger(1)),
            Fill(new PdfInteger(2)),
            Scroll(new PdfInteger(3)),
            Hidden(new PdfInteger(4)),
            Default(new PdfInteger(5));

            private static Map<PdfInteger, FitModeEnum> map;
            private final PdfInteger code;

            static {
                map = new HashMap<PdfInteger, FitModeEnum>();
                FitModeEnum[] fitModeEnumArray = FitModeEnum.values();
                int n = fitModeEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FitModeEnum value = fitModeEnumArray[n2];
                    map.put(value.getCode(), value);
                    ++n2;
                }
            }

            private FitModeEnum(PdfInteger code) {
                this.code = code;
            }

            public PdfInteger getCode() {
                return this.code;
            }

            public static FitModeEnum valueOf(String string) {
                return Enum.valueOf(FitModeEnum.class, string);
            }
        }
    }
}

