/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.multimedia;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.multimedia.Timespan;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF15)
public abstract class MediaOffset<T>
extends PdfObjectWrapper<PdfDictionary> {
    public static MediaOffset<?> wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfDictionary dataObject = (PdfDictionary)baseObject.resolve();
        PdfName offsetType = (PdfName)dataObject.get(PdfName.S);
        if (offsetType == null || dataObject.containsKey(PdfName.Type) && !dataObject.get(PdfName.Type).equals(PdfName.MediaOffset)) {
            return null;
        }
        if (offsetType.equals(PdfName.F)) {
            return new Frame(baseObject);
        }
        if (offsetType.equals(PdfName.M)) {
            return new Marker(baseObject);
        }
        if (offsetType.equals(PdfName.T)) {
            return new Time(baseObject);
        }
        throw new UnsupportedOperationException();
    }

    protected MediaOffset(Document context, PdfName subtype) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.S}, new PdfDirectObject[]{PdfName.MediaOffset, subtype}));
    }

    protected MediaOffset(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    public static final class Frame
    extends MediaOffset<Integer> {
        public Frame(Document context, int value) {
            super(context, PdfName.F);
            this.setValue(value);
        }

        Frame(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Frame clone(Document context) {
            return (Frame)super.clone(context);
        }

        @Override
        public Integer getValue() {
            return ((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.F)).getValue();
        }

        @Override
        public void setValue(Integer value) {
            if (value < 0) {
                throw new IllegalArgumentException("MUST be non-negative.");
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, PdfInteger.get(value));
        }
    }

    public static final class Marker
    extends MediaOffset<String> {
        public Marker(Document context, String value) {
            super(context, PdfName.M);
            this.setValue(value);
        }

        Marker(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Marker clone(Document context) {
            return (Marker)super.clone(context);
        }

        @Override
        public String getValue() {
            return ((PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.M)).getValue();
        }

        @Override
        public void setValue(String value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.M, PdfTextString.get(value));
        }
    }

    public static final class Time
    extends MediaOffset<Double> {
        public Time(Document context, double value) {
            super(context, PdfName.T);
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, new Timespan(value).getBaseObject());
        }

        Time(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Time clone(Document context) {
            return (Time)super.clone(context);
        }

        @Override
        public Double getValue() {
            return this.getTimespan().getTime();
        }

        @Override
        public void setValue(Double value) {
            this.getTimespan().setTime(value);
        }

        private Timespan getTimespan() {
            return new Timespan(((PdfDictionary)this.getBaseDataObject()).get(PdfName.T));
        }
    }
}

