/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interchange.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.util.MapEntry;

@PDF(value=VersionEnum.PDF10)
public final class Information
extends PdfObjectWrapper<PdfDictionary>
implements Map<PdfName, Object> {
    public static Information wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new Information(baseObject) : null;
    }

    public Information(Document context) {
        super(context, new PdfDictionary());
    }

    private Information(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Information clone(Document context) {
        return (Information)super.clone(context);
    }

    public String getAuthor() {
        return (String)this.get(PdfName.Author);
    }

    public Date getCreationDate() {
        return (Date)this.get(PdfName.CreationDate);
    }

    public String getCreator() {
        return (String)this.get(PdfName.Creator);
    }

    @PDF(value=VersionEnum.PDF11)
    public String getKeywords() {
        return (String)this.get(PdfName.Keywords);
    }

    @PDF(value=VersionEnum.PDF11)
    public Date getModificationDate() {
        return (Date)this.get(PdfName.ModDate);
    }

    public String getProducer() {
        return (String)this.get(PdfName.Producer);
    }

    @PDF(value=VersionEnum.PDF11)
    public String getSubject() {
        return (String)this.get(PdfName.Subject);
    }

    @PDF(value=VersionEnum.PDF11)
    public String getTitle() {
        return (String)this.get(PdfName.Title);
    }

    public void setAuthor(String value) {
        this.put(PdfName.Author, (Object)value);
    }

    public void setCreationDate(Date value) {
        this.put(PdfName.CreationDate, (Object)value);
    }

    public void setCreator(String value) {
        this.put(PdfName.Creator, (Object)value);
    }

    public void setKeywords(String value) {
        this.put(PdfName.Keywords, (Object)value);
    }

    public void setModificationDate(Date value) {
        this.put(PdfName.ModDate, (Object)value);
    }

    public void setProducer(String value) {
        this.put(PdfName.Producer, (Object)value);
    }

    public void setSubject(String value) {
        this.put(PdfName.Subject, (Object)value);
    }

    public void setTitle(String value) {
        this.put(PdfName.Title, (Object)value);
    }

    @Override
    public void clear() {
        ((PdfDictionary)this.getBaseDataObject()).clear();
        this.setModificationDate(new Date());
    }

    @Override
    public boolean containsKey(Object key) {
        return ((PdfDictionary)this.getBaseDataObject()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (PdfDirectObject item : ((PdfDictionary)this.getBaseDataObject()).values()) {
            if (!value.equals(PdfSimpleObject.getValue(item))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<PdfName, Object>> entrySet() {
        HashSet<Map.Entry<PdfName, Object>> entrySet = new HashSet<Map.Entry<PdfName, Object>>();
        for (PdfName key : ((PdfDictionary)this.getBaseDataObject()).keySet()) {
            entrySet.add(new MapEntry<PdfName, Object>(key, this.get(key)));
        }
        return entrySet;
    }

    @Override
    public Object get(Object key) {
        return PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(key));
    }

    @Override
    public boolean isEmpty() {
        return ((PdfDictionary)this.getBaseDataObject()).isEmpty();
    }

    @Override
    public Set<PdfName> keySet() {
        return ((PdfDictionary)this.getBaseDataObject()).keySet();
    }

    @Override
    public Object put(PdfName key, Object value) {
        this.onChange(key);
        return PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).put(key, PdfSimpleObject.get(value)));
    }

    @Override
    public void putAll(Map<? extends PdfName, ? extends Object> map) {
        for (Map.Entry<? extends PdfName, ? extends Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        this.onChange((PdfName)key);
        return PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).remove(key));
    }

    @Override
    public int size() {
        return ((PdfDictionary)this.getBaseDataObject()).size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (PdfDirectObject item : ((PdfDictionary)this.getBaseDataObject()).values()) {
            values.add(PdfSimpleObject.getValue(item));
        }
        return values;
    }

    private void onChange(PdfName key) {
        if (!((PdfDictionary)this.getBaseDataObject()).isUpdated() && !PdfName.ModDate.equals(key)) {
            this.setModificationDate(new Date());
        }
    }
}

