/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.viewer;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfSimpleObject;

@PDF(value=VersionEnum.PDF12)
public final class ViewerPreferences
extends PdfObjectWrapper<PdfDictionary> {
    public static ViewerPreferences wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new ViewerPreferences(baseObject) : null;
    }

    public ViewerPreferences(Document context) {
        super(context, new PdfDictionary());
    }

    private ViewerPreferences(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public ViewerPreferences clone(Document context) {
        return (ViewerPreferences)super.clone(context);
    }

    public DirectionEnum getDirection() {
        PdfName directionObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Direction);
        return directionObject != null ? DirectionEnum.get(directionObject) : DirectionEnum.LeftToRight;
    }

    public boolean isCenterWindow() {
        return (Boolean)this.get(PdfName.CenterWindow, false);
    }

    public boolean isDisplayDocTitle() {
        return (Boolean)this.get(PdfName.DisplayDocTitle, false);
    }

    public boolean isFitWindow() {
        return (Boolean)this.get(PdfName.FitWindow, false);
    }

    public boolean isHideMenubar() {
        return (Boolean)this.get(PdfName.HideMenubar, false);
    }

    public boolean isHideToolbar() {
        return (Boolean)this.get(PdfName.HideToolbar, false);
    }

    public boolean isHideWindowUI() {
        return (Boolean)this.get(PdfName.HideWindowUI, false);
    }

    public void setCenterWindow(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CenterWindow, PdfBoolean.get(value));
    }

    public void setDirection(DirectionEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Direction, value == null ? null : value.getCode());
    }

    public void setDisplayDocTitle(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DisplayDocTitle, PdfBoolean.get(value));
    }

    public void setFitWindow(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.FitWindow, PdfBoolean.get(value));
    }

    public void setHideMenubar(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.HideMenubar, PdfBoolean.get(value));
    }

    public void setHideToolbar(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.HideToolbar, PdfBoolean.get(value));
    }

    public void setHideWindowUI(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.HideWindowUI, PdfBoolean.get(value));
    }

    private Object get(PdfName key, Object defaultValue) {
        return PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(key), defaultValue);
    }

    public static enum DirectionEnum {
        LeftToRight(PdfName.L2R),
        RightToLeft(PdfName.R2L);

        private final PdfName code;

        public static DirectionEnum get(PdfName value) {
            DirectionEnum[] directionEnumArray = DirectionEnum.values();
            int n = directionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirectionEnum direction = directionEnumArray[n2];
                if (direction.getCode().equals(value)) {
                    return direction;
                }
                ++n2;
            }
            return null;
        }

        private DirectionEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

