/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.navigation.page;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfSimpleObject;

@PDF(value=VersionEnum.PDF11)
public final class Transition
extends PdfObjectWrapper<PdfDictionary> {
    public static Transition wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new Transition(baseObject) : null;
    }

    public Transition(Document context) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Trans}));
    }

    public Transition(Document context, StyleEnum style) {
        this(context, style, null, null, null, null, null);
    }

    public Transition(Document context, StyleEnum style, Double duration) {
        this(context, style, duration, null, null, null, null);
    }

    public Transition(Document context, StyleEnum style, Double duration, OrientationEnum orientation, PageDirectionEnum pageDirection, DirectionEnum direction, Double scale) {
        this(context);
        this.setStyle(style);
        this.setDuration(duration);
        this.setOrientation(orientation);
        this.setPageDirection(pageDirection);
        this.setDirection(direction);
        this.setScale(scale);
    }

    private Transition(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Transition clone(Document context) {
        return (Transition)super.clone(context);
    }

    public DirectionEnum getDirection() {
        PdfSimpleObject directionObject = (PdfSimpleObject)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Di);
        return directionObject == null ? DirectionEnum.LeftToRight : DirectionEnum.get(directionObject);
    }

    public double getDuration() {
        PdfNumber durationObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
        return durationObject == null ? 1.0 : durationObject.getDoubleValue();
    }

    public OrientationEnum getOrientation() {
        PdfName orientationObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dm);
        return orientationObject == null ? OrientationEnum.Horizontal : OrientationEnum.get(orientationObject);
    }

    public PageDirectionEnum getPageDirection() {
        PdfName pageDirectionObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.M);
        return pageDirectionObject == null ? PageDirectionEnum.Inward : PageDirectionEnum.get(pageDirectionObject);
    }

    @PDF(value=VersionEnum.PDF15)
    public double getScale() {
        PdfNumber scaleObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.SS);
        return scaleObject == null ? 1.0 : scaleObject.getDoubleValue();
    }

    public StyleEnum getStyle() {
        PdfName styleObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S);
        return styleObject == null ? StyleEnum.Replace : StyleEnum.get(styleObject);
    }

    public void setDirection(DirectionEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Di);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Di, value.getCode());
        }
    }

    public void setDuration(Double value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.D);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, PdfReal.get(value));
        }
    }

    public void setOrientation(OrientationEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dm);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dm, value.getCode());
        }
    }

    public void setPageDirection(PageDirectionEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.M);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.M, value.getCode());
        }
    }

    public void setScale(Double value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.SS);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.SS, PdfReal.get(value));
        }
    }

    public void setStyle(StyleEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.S);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, value.getCode());
        }
    }

    public static enum DirectionEnum {
        LeftToRight(PdfInteger.get(0)),
        BottomToTop(PdfInteger.get(90)),
        RightToLeft(PdfInteger.get(180)),
        TopToBottom(PdfInteger.get(270)),
        TopLeftToBottomRight(PdfInteger.get(315)),
        None(PdfName.None);

        private final PdfSimpleObject<?> code;

        public static DirectionEnum get(PdfSimpleObject<?> value) {
            DirectionEnum[] directionEnumArray = DirectionEnum.values();
            int n = directionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirectionEnum direction = directionEnumArray[n2];
                if (direction.getCode().equals(value)) {
                    return direction;
                }
                ++n2;
            }
            return null;
        }

        private DirectionEnum(PdfSimpleObject<?> code) {
            this.code = code;
        }

        public PdfSimpleObject<?> getCode() {
            return this.code;
        }
    }

    public static enum OrientationEnum {
        Horizontal(PdfName.H),
        Vertical(PdfName.V);

        private final PdfName code;

        public static OrientationEnum get(PdfName value) {
            OrientationEnum[] orientationEnumArray = OrientationEnum.values();
            int n = orientationEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrientationEnum orientation = orientationEnumArray[n2];
                if (orientation.getCode().equals(value)) {
                    return orientation;
                }
                ++n2;
            }
            return null;
        }

        private OrientationEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }

    public static enum PageDirectionEnum {
        Inward(PdfName.I),
        Outward(PdfName.O);

        private final PdfName code;

        public static PageDirectionEnum get(PdfName value) {
            PageDirectionEnum[] pageDirectionEnumArray = PageDirectionEnum.values();
            int n = pageDirectionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                PageDirectionEnum direction = pageDirectionEnumArray[n2];
                if (direction.getCode().equals(value)) {
                    return direction;
                }
                ++n2;
            }
            return null;
        }

        private PageDirectionEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }

    public static enum StyleEnum {
        Split(PdfName.Split),
        Blinds(PdfName.Blinds),
        Box(PdfName.Box),
        Wipe(PdfName.Wipe),
        Dissolve(PdfName.Dissolve),
        Glitter(PdfName.Glitter),
        Replace(PdfName.R),
        Fly(PdfName.Fly),
        Push(PdfName.Push),
        Cover(PdfName.Cover),
        Uncover(PdfName.Uncover),
        Fade(PdfName.Fade);

        private final PdfName code;

        public static StyleEnum get(PdfName value) {
            StyleEnum[] styleEnumArray = StyleEnum.values();
            int n = styleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleEnum style = styleEnumArray[n2];
                if (style.getCode().equals(value)) {
                    return style;
                }
                ++n2;
            }
            return null;
        }

        private StyleEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

