/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.navigation.page;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF13)
public final class PageLabel
extends PdfObjectWrapper<PdfDictionary> {
    private static final int DefaultNumberBase = 1;

    public static PageLabel wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new PageLabel(baseObject) : null;
    }

    public PageLabel(Document context, NumberStyleEnum numberStyle) {
        this(context, null, numberStyle, 1);
    }

    public PageLabel(Document context, String prefix, NumberStyleEnum numberStyle, int numberBase) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.PageLabel}));
        this.setPrefix(prefix);
        this.setNumberStyle(numberStyle);
        this.setNumberBase(numberBase);
    }

    private PageLabel(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public PageLabel clone(Document context) {
        return (PageLabel)super.clone(context);
    }

    public int getNumberBase() {
        return (Integer)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.St), 1);
    }

    public NumberStyleEnum getNumberStyle() {
        return NumberStyleEnum.get((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S));
    }

    public String getPrefix() {
        return (String)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.P));
    }

    public void setNumberBase(int value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.St, value <= 1 ? null : PdfInteger.get(value));
    }

    public void setNumberStyle(NumberStyleEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, value != null ? value.getCode() : null);
    }

    public void setPrefix(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, PdfTextString.get(value));
    }

    public static enum NumberStyleEnum {
        ArabicNumber(PdfName.D),
        UCaseRomanNumber(PdfName.R),
        LCaseRomanNumber(PdfName.r),
        UCaseLetter(PdfName.A),
        LCaseLetter(PdfName.a);

        private final PdfName code;

        public static NumberStyleEnum get(PdfName value) {
            NumberStyleEnum[] numberStyleEnumArray = NumberStyleEnum.values();
            int n = numberStyleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                NumberStyleEnum numberStyle = numberStyleEnumArray[n2];
                if (numberStyle.getCode().equals(value)) {
                    return numberStyle;
                }
                ++n2;
            }
            return null;
        }

        private NumberStyleEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

