/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.navigation.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.interaction.navigation.page.ArticleElement;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.util.IPredicate;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF11)
public class ArticleElements
extends PdfObjectWrapper<PdfDictionary>
implements List<ArticleElement> {
    public static ArticleElements wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new ArticleElements(baseObject) : null;
    }

    private ArticleElements(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public boolean add(ArticleElement object) {
        PdfDictionary itemBead = (PdfDictionary)object.getBaseDataObject();
        PdfDictionary firstBead = this.getFirstBead();
        if (firstBead != null) {
            this.link(itemBead, firstBead);
        } else {
            this.setFirstBead(itemBead);
            this.link(itemBead, itemBead);
        }
        return true;
    }

    @Override
    public void add(int index, ArticleElement object) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ElementGetter getter = new ElementGetter(index);
        this.iterate(getter);
        PdfDictionary bead = getter.getBead();
        if (bead == null) {
            this.add(object);
        } else {
            this.link((PdfDictionary)object.getBaseDataObject(), bead);
        }
    }

    @Override
    public boolean addAll(Collection<? extends ArticleElement> objects) {
        throw new NotImplementedException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends ArticleElement> objects) {
        throw new NotImplementedException();
    }

    @Override
    public void clear() {
        throw new NotImplementedException();
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        throw new NotImplementedException();
    }

    @Override
    public ArticleElement get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ElementGetter getter = new ElementGetter(index);
        this.iterate(getter);
        PdfDictionary bead = getter.getBead();
        if (bead == null) {
            throw new IndexOutOfBoundsException();
        }
        return ArticleElement.wrap(bead.getReference());
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        ElementIndexer indexer = new ElementIndexer((PdfDictionary)((ArticleElement)object).getBaseDataObject());
        this.iterate(indexer);
        return indexer.getIndex();
    }

    @Override
    public boolean isEmpty() {
        return this.getFirstBead() == null;
    }

    @Override
    public Iterator<ArticleElement> iterator() {
        return new Iterator<ArticleElement>(){
            private PdfDirectObject currentObject = null;
            private final PdfDirectObject firstObject;
            private PdfDirectObject nextObject;
            {
                this.nextObject = this.firstObject = ((PdfDictionary)ArticleElements.this.getBaseDataObject()).get(PdfName.F);
            }

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public ArticleElement next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.currentObject = this.nextObject;
                this.nextObject = ((PdfDictionary)this.currentObject.resolve()).get(PdfName.N);
                if (this.nextObject == this.firstObject) {
                    this.nextObject = null;
                }
                return ArticleElement.wrap(this.currentObject);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public ListIterator<ArticleElement> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<ArticleElement> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public boolean remove(Object object) {
        if (!this.contains(object)) {
            return false;
        }
        this.unlink((PdfDictionary)((ArticleElement)object).getBaseDataObject());
        return true;
    }

    @Override
    public ArticleElement remove(int index) {
        ArticleElement item = this.get(index);
        this.unlink((PdfDictionary)item.getBaseDataObject());
        return item;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object object : objects) {
            if (!this.remove(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        for (ArticleElement item : this) {
            if (objects.contains(item)) continue;
            this.unlink((PdfDictionary)item.getBaseDataObject());
        }
        return false;
    }

    @Override
    public ArticleElement set(int index, ArticleElement object) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        ElementCounter counter = new ElementCounter();
        this.iterate(counter);
        return counter.getCount();
    }

    @Override
    public List<ArticleElement> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new ArticleElement[0]);
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        ElementListBuilder builder = new ElementListBuilder();
        this.iterate(builder);
        if (objects.length < builder.getElements().size()) {
            objects = new Object[builder.getElements().size()];
        }
        builder.getElements().toArray(objects);
        return objects;
    }

    private PdfDictionary getFirstBead() {
        return (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.F);
    }

    private void iterate(IPredicate predicate) {
        PdfDictionary firstBead;
        PdfDictionary bead = firstBead = this.getFirstBead();
        while (bead != null) {
            if (predicate.evaluate(bead) || (bead = (PdfDictionary)bead.resolve(PdfName.N)) == firstBead) break;
        }
    }

    private void link(PdfDictionary item, PdfDictionary next) {
        PdfDictionary previous = (PdfDictionary)next.resolve(PdfName.V);
        if (previous == null) {
            previous = next;
        }
        item.put(PdfName.N, next.getReference());
        next.put(PdfName.V, item.getReference());
        if (previous != item) {
            item.put(PdfName.V, previous.getReference());
            previous.put(PdfName.N, item.getReference());
        }
    }

    private void setFirstBead(PdfDictionary value) {
        PdfDictionary oldValue = (PdfDictionary)PdfObject.resolve(((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, PdfObject.unresolve(value)));
        if (value != null) {
            value.put(PdfName.T, this.getBaseObject());
        }
        if (oldValue != null) {
            oldValue.remove(PdfName.T);
        }
    }

    private void unlink(PdfDictionary item) {
        PdfDictionary prevBead = (PdfDictionary)item.remove(PdfName.V).resolve();
        PdfDictionary nextBead = (PdfDictionary)item.remove(PdfName.N).resolve();
        if (prevBead != item) {
            prevBead.put(PdfName.N, nextBead.getReference());
            nextBead.put(PdfName.V, prevBead.getReference());
            if (item == this.getFirstBead()) {
                this.setFirstBead(nextBead);
            }
        } else {
            this.setFirstBead(null);
        }
    }

    private static final class ElementCounter
    extends ElementEvaluator {
        private ElementCounter() {
        }

        public int getCount() {
            return this.index + 1;
        }
    }

    private static class ElementEvaluator
    implements IPredicate {
        protected int index = -1;

        private ElementEvaluator() {
        }

        @Override
        public boolean evaluate(Object object) {
            ++this.index;
            return false;
        }
    }

    private static final class ElementGetter
    extends ElementEvaluator {
        private PdfDictionary bead;
        private final int beadIndex;

        public ElementGetter(int beadIndex) {
            this.beadIndex = beadIndex;
        }

        @Override
        public boolean evaluate(Object object) {
            super.evaluate(object);
            if (this.index == this.beadIndex) {
                this.bead = (PdfDictionary)object;
                return true;
            }
            return false;
        }

        public PdfDictionary getBead() {
            return this.bead;
        }
    }

    private static final class ElementIndexer
    extends ElementEvaluator {
        private final PdfDictionary searchedBead;

        public ElementIndexer(PdfDictionary searchedBead) {
            this.searchedBead = searchedBead;
        }

        @Override
        public boolean evaluate(Object object) {
            super.evaluate(object);
            return object.equals(this.searchedBead);
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static final class ElementListBuilder
    extends ElementEvaluator {
        public List<ArticleElement> elements = new ArrayList<ArticleElement>();

        private ElementListBuilder() {
        }

        @Override
        public boolean evaluate(Object object) {
            this.elements.add(ArticleElement.wrap((PdfDirectObject)object));
            return false;
        }

        public List<ArticleElement> getElements() {
            return this.elements;
        }
    }
}

