/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms.styles;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColor;
import org.pdfclown.documents.contents.composition.BlockComposer;
import org.pdfclown.documents.contents.composition.PrimitiveComposer;
import org.pdfclown.documents.contents.composition.XAlignmentEnum;
import org.pdfclown.documents.contents.composition.YAlignmentEnum;
import org.pdfclown.documents.contents.fonts.StandardType1Font;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.interaction.annotations.Appearance;
import org.pdfclown.documents.interaction.annotations.AppearanceStates;
import org.pdfclown.documents.interaction.annotations.DualWidget;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.documents.interaction.forms.CheckBox;
import org.pdfclown.documents.interaction.forms.ChoiceItem;
import org.pdfclown.documents.interaction.forms.ComboBox;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.documents.interaction.forms.ListBox;
import org.pdfclown.documents.interaction.forms.PushButton;
import org.pdfclown.documents.interaction.forms.RadioButton;
import org.pdfclown.documents.interaction.forms.TextField;
import org.pdfclown.documents.interaction.forms.styles.FieldStyle;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfString;
import org.pdfclown.util.math.geom.Dimension;

public final class DefaultStyle
extends FieldStyle {
    public DefaultStyle() {
        this.setBackColor(new DeviceRGBColor(0.9, 0.9, 0.9));
    }

    @Override
    public void apply(Field field) {
        if (field instanceof PushButton) {
            this.apply((PushButton)field);
        } else if (field instanceof CheckBox) {
            this.apply((CheckBox)field);
        } else if (field instanceof TextField) {
            this.apply((TextField)field);
        } else if (field instanceof ComboBox) {
            this.apply((ComboBox)field);
        } else if (field instanceof ListBox) {
            this.apply((ListBox)field);
        } else if (field instanceof RadioButton) {
            this.apply((RadioButton)field);
        }
    }

    private void apply(CheckBox field) {
        Document document = field.getDocument();
        for (Widget widget : field.getWidgets()) {
            PdfDictionary widgetDataObject = (PdfDictionary)widget.getBaseDataObject();
            widgetDataObject.put(PdfName.DA, new PdfString("/ZaDb 0 Tf 0 0 0 rg"));
            widgetDataObject.put(PdfName.MK, new PdfDictionary(new PdfName[]{PdfName.BG, PdfName.BC, PdfName.CA}, new PdfDirectObject[]{new PdfArray(PdfReal.get(0.9412), PdfReal.get(0.9412), PdfReal.get(0.9412)), new PdfArray(PdfInteger.Default, PdfInteger.Default, PdfInteger.Default), new PdfString("4")}));
            widgetDataObject.put(PdfName.BS, new PdfDictionary(new PdfName[]{PdfName.W, PdfName.S}, new PdfDirectObject[]{PdfReal.get(0.8), PdfName.S}));
            widgetDataObject.put(PdfName.H, PdfName.P);
            Appearance appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new Appearance(document);
                widget.setAppearance(appearance);
            }
            Dimension size = Dimension.get(widget.getBox());
            AppearanceStates normalAppearance = appearance.getNormal();
            FormXObject onState = new FormXObject(document, size);
            normalAppearance.put(PdfName.Yes, onState);
            double lineWidth = 1.0;
            Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
            PrimitiveComposer composer = new PrimitiveComposer(onState);
            if (this.isGraphicsVisibile()) {
                composer.beginLocalState();
                composer.setLineWidth(lineWidth);
                composer.setFillColor(this.getBackColor());
                composer.setStrokeColor(this.getForeColor());
                composer.drawRectangle(frame, 5.0);
                composer.fillStroke();
                composer.end();
            }
            BlockComposer blockComposer = new BlockComposer(composer);
            blockComposer.begin(frame, XAlignmentEnum.Center, YAlignmentEnum.Middle);
            composer.setFillColor(this.getForeColor());
            composer.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.ZapfDingbats, true, false), ((Dimension2D)size).getHeight() * 0.8);
            blockComposer.showText(new String(new char[]{this.getCheckSymbol()}));
            blockComposer.end();
            composer.flush();
            FormXObject offState = new FormXObject(document, size);
            normalAppearance.put(PdfName.Off, offState);
            if (!this.isGraphicsVisibile()) continue;
            PrimitiveComposer composer2 = new PrimitiveComposer(offState);
            composer2.beginLocalState();
            composer2.setLineWidth(lineWidth);
            composer2.setFillColor(this.getBackColor());
            composer2.setStrokeColor(this.getForeColor());
            composer2.drawRectangle(frame, 5.0);
            composer2.fillStroke();
            composer2.end();
            composer2.flush();
        }
    }

    private void apply(RadioButton field) {
        Document document = field.getDocument();
        for (Widget widget : field.getWidgets()) {
            PdfDictionary widgetDataObject = (PdfDictionary)widget.getBaseDataObject();
            widgetDataObject.put(PdfName.DA, new PdfString("/ZaDb 0 Tf 0 0 0 rg"));
            widgetDataObject.put(PdfName.MK, new PdfDictionary(new PdfName[]{PdfName.BG, PdfName.BC, PdfName.CA}, new PdfDirectObject[]{new PdfArray(PdfReal.get(0.9412), PdfReal.get(0.9412), PdfReal.get(0.9412)), new PdfArray(PdfInteger.Default, PdfInteger.Default, PdfInteger.Default), new PdfString("l")}));
            widgetDataObject.put(PdfName.BS, new PdfDictionary(new PdfName[]{PdfName.W, PdfName.S}, new PdfDirectObject[]{PdfReal.get(0.8), PdfName.S}));
            widgetDataObject.put(PdfName.H, PdfName.P);
            Appearance appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new Appearance(document);
                widget.setAppearance(appearance);
            }
            AppearanceStates normalAppearance = appearance.getNormal();
            FormXObject onState = normalAppearance.get(new PdfName(((DualWidget)widget).getWidgetName()));
            Dimension size = Dimension.get(widget.getBox());
            double lineWidth = 1.0;
            Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
            PrimitiveComposer composer = new PrimitiveComposer(onState);
            if (this.isGraphicsVisibile()) {
                composer.beginLocalState();
                composer.setLineWidth(lineWidth);
                composer.setFillColor(this.getBackColor());
                composer.setStrokeColor(this.getForeColor());
                composer.drawEllipse(frame);
                composer.fillStroke();
                composer.end();
            }
            BlockComposer blockComposer = new BlockComposer(composer);
            blockComposer.begin(frame, XAlignmentEnum.Center, YAlignmentEnum.Middle);
            composer.setFillColor(this.getForeColor());
            composer.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.ZapfDingbats, true, false), ((Dimension2D)size).getHeight() * 0.8);
            blockComposer.showText(new String(new char[]{this.getRadioSymbol()}));
            blockComposer.end();
            composer.flush();
            FormXObject offState = new FormXObject(document, size);
            normalAppearance.put(PdfName.Off, offState);
            if (!this.isGraphicsVisibile()) continue;
            PrimitiveComposer composer2 = new PrimitiveComposer(offState);
            composer2.beginLocalState();
            composer2.setLineWidth(lineWidth);
            composer2.setFillColor(this.getBackColor());
            composer2.setStrokeColor(this.getForeColor());
            composer2.drawEllipse(frame);
            composer2.fillStroke();
            composer2.end();
            composer2.flush();
        }
    }

    private void apply(PushButton field) {
        String title;
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        Dimension size = Dimension.get(widget.getBox());
        FormXObject normalAppearanceState = new FormXObject(document, size);
        PrimitiveComposer composer = new PrimitiveComposer(normalAppearanceState);
        double lineWidth = 1.0;
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        if (this.isGraphicsVisibile()) {
            composer.beginLocalState();
            composer.setLineWidth(lineWidth);
            composer.setFillColor(this.getBackColor());
            composer.setStrokeColor(this.getForeColor());
            composer.drawRectangle(frame, 5.0);
            composer.fillStroke();
            composer.end();
        }
        if ((title = (String)field.getValue()) != null) {
            BlockComposer blockComposer = new BlockComposer(composer);
            blockComposer.begin(frame, XAlignmentEnum.Center, YAlignmentEnum.Middle);
            composer.setFillColor(this.getForeColor());
            composer.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, true, false), ((Dimension2D)size).getHeight() * 0.5);
            blockComposer.showText(title);
            blockComposer.end();
        }
        composer.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }

    private void apply(TextField field) {
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        ((PdfDictionary)widget.getBaseDataObject()).put(PdfName.DA, new PdfString("/Helv " + this.getFontSize() + " Tf 0 0 0 rg"));
        Dimension size = Dimension.get(widget.getBox());
        FormXObject normalAppearanceState = new FormXObject(document, size);
        PrimitiveComposer composer = new PrimitiveComposer(normalAppearanceState);
        double lineWidth = 1.0;
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        if (this.isGraphicsVisibile()) {
            composer.beginLocalState();
            composer.setLineWidth(lineWidth);
            composer.setFillColor(this.getBackColor());
            composer.setStrokeColor(this.getForeColor());
            composer.drawRectangle(frame, 5.0);
            composer.fillStroke();
            composer.end();
        }
        composer.beginMarkedContent(PdfName.Tx);
        composer.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, false, false), this.getFontSize());
        composer.showText((String)field.getValue(), new Point2D.Double(0.0, ((Dimension2D)size).getHeight() / 2.0), XAlignmentEnum.Left, YAlignmentEnum.Middle, 0.0);
        composer.end();
        composer.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }

    private void apply(ComboBox field) {
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        ((PdfDictionary)widget.getBaseDataObject()).put(PdfName.DA, new PdfString("/Helv " + this.getFontSize() + " Tf 0 0 0 rg"));
        Dimension size = Dimension.get(widget.getBox());
        FormXObject normalAppearanceState = new FormXObject(document, size);
        PrimitiveComposer composer = new PrimitiveComposer(normalAppearanceState);
        double lineWidth = 1.0;
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        if (this.isGraphicsVisibile()) {
            composer.beginLocalState();
            composer.setLineWidth(lineWidth);
            composer.setFillColor(this.getBackColor());
            composer.setStrokeColor(this.getForeColor());
            composer.drawRectangle(frame, 5.0);
            composer.fillStroke();
            composer.end();
        }
        composer.beginMarkedContent(PdfName.Tx);
        composer.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, false, false), this.getFontSize());
        composer.showText((String)field.getValue(), new Point2D.Double(0.0, ((Dimension2D)size).getHeight() / 2.0), XAlignmentEnum.Left, YAlignmentEnum.Middle, 0.0);
        composer.end();
        composer.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }

    private void apply(ListBox field) {
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        PdfDictionary widgetDataObject = (PdfDictionary)widget.getBaseDataObject();
        widgetDataObject.put(PdfName.DA, new PdfString("/Helv " + this.getFontSize() + " Tf 0 0 0 rg"));
        widgetDataObject.put(PdfName.MK, new PdfDictionary(new PdfName[]{PdfName.BG, PdfName.BC}, new PdfDirectObject[]{new PdfArray(PdfReal.get(0.9), PdfReal.get(0.9), PdfReal.get(0.9)), new PdfArray(PdfInteger.Default, PdfInteger.Default, PdfInteger.Default)}));
        Dimension size = Dimension.get(widget.getBox());
        FormXObject normalAppearanceState = new FormXObject(document, size);
        PrimitiveComposer composer = new PrimitiveComposer(normalAppearanceState);
        double lineWidth = 1.0;
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        if (this.isGraphicsVisibile()) {
            composer.beginLocalState();
            composer.setLineWidth(lineWidth);
            composer.setFillColor(this.getBackColor());
            composer.setStrokeColor(this.getForeColor());
            composer.drawRectangle(frame, 5.0);
            composer.fillStroke();
            composer.end();
        }
        composer.beginLocalState();
        if (this.isGraphicsVisibile()) {
            composer.drawRectangle(frame, 5.0);
            composer.clip();
        }
        composer.beginMarkedContent(PdfName.Tx);
        composer.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, false, false), this.getFontSize());
        double y = 3.0;
        for (ChoiceItem item : field.getItems()) {
            composer.showText(item.getText(), new Point2D.Double(0.0, y));
            if ((y += this.getFontSize() * 1.175) > ((Dimension2D)size).getHeight()) break;
        }
        composer.end();
        composer.end();
        composer.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }
}

