/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.documents.interaction.forms.ChoiceField;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.util.EnumUtils;

@PDF(value=VersionEnum.PDF12)
public final class ComboBox
extends ChoiceField {
    public ComboBox(String name, Widget widget) {
        super(name, widget);
        this.setFlags(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.Combo, true));
    }

    ComboBox(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public ComboBox clone(Document context) {
        return (ComboBox)super.clone(context);
    }

    public boolean isEditable() {
        return this.getFlags().contains((Object)Field.FlagsEnum.Edit);
    }

    public boolean isSpellChecked() {
        return !this.getFlags().contains((Object)Field.FlagsEnum.DoNotSpellCheck);
    }

    public void setEditable(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.Edit, value));
    }

    public void setSpellChecked(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.DoNotSpellCheck, !value));
    }
}

