/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF13)
public final class RubberStamp
extends Annotation {
    public RubberStamp(Page page, Rectangle2D box, String text, IconTypeEnum iconType) {
        super(page, PdfName.Stamp, box, text);
        this.setIconType(iconType);
    }

    RubberStamp(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public RubberStamp clone(Document context) {
        return (RubberStamp)super.clone(context);
    }

    public IconTypeEnum getIconType() {
        PdfName nameObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name);
        return nameObject != null ? IconTypeEnum.get(nameObject) : IconTypeEnum.Draft;
    }

    public void setIconType(IconTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, value.getCode());
    }

    public static enum IconTypeEnum {
        Approved(PdfName.Approved),
        AsIs(PdfName.AsIs),
        Confidential(PdfName.Confidential),
        Departmental(PdfName.Departmental),
        Draft(PdfName.Draft),
        Experimental(PdfName.Experimental),
        Expired(PdfName.Expired),
        Final(PdfName.Final),
        ForComment(PdfName.ForComment),
        ForPublicRelease(PdfName.ForPublicRelease),
        NotApproved(PdfName.NotApproved),
        NotForPublicRelease(PdfName.NotForPublicRelease),
        Sold(PdfName.Sold),
        TopSecret(PdfName.TopSecret);

        private final PdfName code;

        public static IconTypeEnum get(PdfName value) {
            IconTypeEnum[] iconTypeEnumArray = IconTypeEnum.values();
            int n = iconTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconTypeEnum iconType = iconTypeEnumArray[n2];
                if (iconType.getCode().equals(value)) {
                    return iconType;
                }
                ++n2;
            }
            return null;
        }

        private IconTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

