/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.ILink;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.documents.interaction.navigation.document.Destination;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;

@PDF(value=VersionEnum.PDF10)
public final class Link
extends Annotation
implements ILink {
    public Link(Page page, Rectangle2D box, String text, PdfObjectWrapper<?> target) {
        super(page, PdfName.Link, box, text);
        this.setTarget(target);
    }

    Link(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Link clone(Document context) {
        return (Link)super.clone(context);
    }

    @Override
    public void setAction(Action value) {
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest) && value != null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
        }
        super.setAction(value);
    }

    @Override
    public PdfObjectWrapper<?> getTarget() {
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest)) {
            return this.getDestination();
        }
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
            return this.getAction();
        }
        return null;
    }

    @Override
    public void setTarget(PdfObjectWrapper<?> value) {
        if (value instanceof Destination) {
            this.setDestination((Destination)value);
        } else if (value instanceof Action) {
            this.setAction((Action)value);
        } else {
            throw new IllegalArgumentException("It MUST be either a Destination or an Action.");
        }
    }

    private Destination getDestination() {
        PdfDirectObject destinationObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dest);
        return destinationObject != null ? this.getDocument().resolveName(Destination.class, destinationObject) : null;
    }

    private void setDestination(Destination value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
        } else {
            if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dest, value.getNamedBaseObject());
        }
    }
}

