/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColor;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF13)
public final class Line
extends Annotation {
    private static final double DefaultLeaderLineExtensionLength = 0.0;
    private static final double DefaultLeaderLineLength = 0.0;
    private static final LineEndStyleEnum DefaultLineEndStyle = LineEndStyleEnum.None;

    public Line(Page page, Point2D startPoint, Point2D endPoint, String text) {
        super(page, PdfName.Line, new Rectangle2D.Double(startPoint.getX(), startPoint.getY(), endPoint.getX() - startPoint.getX(), endPoint.getY() - startPoint.getY()), text);
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.L, new PdfArray(PdfReal.get(0), PdfReal.get(0), PdfReal.get(0), PdfReal.get(0)));
        this.setStartPoint(startPoint);
        this.setEndPoint(endPoint);
    }

    Line(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Line clone(Document context) {
        return (Line)super.clone(context);
    }

    public Point2D getEndPoint() {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        return new Point2D.Double(((PdfNumber)coordinatesObject.get(2)).getDoubleValue(), ((PdfNumber)coordinatesObject.get(3)).getDoubleValue());
    }

    public LineEndStyleEnum getEndStyle() {
        PdfArray endstylesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LE);
        return endstylesObject != null ? LineEndStyleEnum.get((PdfName)endstylesObject.get(1)) : DefaultLineEndStyle;
    }

    public DeviceRGBColor getFillColor() {
        PdfArray fillColorObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.IC);
        if (fillColorObject == null) {
            return null;
        }
        return new DeviceRGBColor(((PdfNumber)fillColorObject.get(0)).getDoubleValue(), ((PdfNumber)fillColorObject.get(1)).getDoubleValue(), ((PdfNumber)fillColorObject.get(2)).getDoubleValue());
    }

    public double getLeaderLineExtensionLength() {
        PdfNumber leaderLineExtensionLengthObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LLE);
        return leaderLineExtensionLengthObject != null ? leaderLineExtensionLengthObject.getDoubleValue() : 0.0;
    }

    public double getLeaderLineLength() {
        PdfNumber leaderLineLengthObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LL);
        return leaderLineLengthObject != null ? -leaderLineLengthObject.getDoubleValue() : 0.0;
    }

    public Point2D getStartPoint() {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        return new Point2D.Double(((PdfNumber)coordinatesObject.get(0)).getDoubleValue(), ((PdfNumber)coordinatesObject.get(1)).getDoubleValue());
    }

    public LineEndStyleEnum getStartStyle() {
        PdfArray endstylesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LE);
        return endstylesObject != null ? LineEndStyleEnum.get((PdfName)endstylesObject.get(0)) : DefaultLineEndStyle;
    }

    public boolean isCaptionVisible() {
        PdfBoolean captionVisibleObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Cap);
        return captionVisibleObject != null ? captionVisibleObject.getValue() : false;
    }

    public void setCaptionVisible(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Cap, PdfBoolean.get(value));
    }

    public void setEndPoint(Point2D value) {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        coordinatesObject.set(2, PdfReal.get(value.getX()));
        coordinatesObject.set(3, PdfReal.get(this.getPage().getBox().getHeight() - value.getY()));
    }

    public void setEndStyle(LineEndStyleEnum value) {
        this.ensureLineEndStylesObject().set(1, value.getCode());
    }

    public void setFillColor(DeviceRGBColor value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.IC, (PdfDirectObject)value.getBaseDataObject());
    }

    public void setLeaderLineExtensionLength(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LLE, PdfReal.get(value));
        if (!((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.LL)) {
            this.setLeaderLineLength(0.0);
        }
    }

    public void setLeaderLineLength(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LL, PdfReal.get(-value));
    }

    public void setStartPoint(Point2D value) {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        coordinatesObject.set(0, PdfReal.get(value.getX()));
        coordinatesObject.set(1, PdfReal.get(this.getPage().getBox().getHeight() - value.getY()));
    }

    public void setStartStyle(LineEndStyleEnum value) {
        this.ensureLineEndStylesObject().set(0, value.getCode());
    }

    private PdfArray ensureLineEndStylesObject() {
        PdfArray endStylesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LE);
        if (endStylesObject == null) {
            endStylesObject = new PdfArray(DefaultLineEndStyle.getCode(), DefaultLineEndStyle.getCode());
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LE, endStylesObject);
        }
        return endStylesObject;
    }

    public static enum LineEndStyleEnum {
        Square(PdfName.Square),
        Circle(PdfName.Circle),
        Diamond(PdfName.Diamond),
        OpenArrow(PdfName.OpenArrow),
        ClosedArrow(PdfName.ClosedArrow),
        None(PdfName.None),
        Butt(PdfName.Butt),
        ReverseOpenArrow(PdfName.ROpenArrow),
        ReverseClosedArrow(PdfName.RClosedArrow),
        Slash(PdfName.Slash);

        private final PdfName code;

        public static LineEndStyleEnum get(PdfName value) {
            LineEndStyleEnum[] lineEndStyleEnumArray = LineEndStyleEnum.values();
            int n = lineEndStyleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineEndStyleEnum style = lineEndStyleEnumArray[n2];
                if (style.getCode().equals(value)) {
                    return style;
                }
                ++n2;
            }
            return null;
        }

        private LineEndStyleEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

