/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.colorSpaces.DeviceColor;
import org.pdfclown.documents.contents.composition.XAlignmentEnum;
import org.pdfclown.documents.contents.composition.YAlignmentEnum;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF12)
public final class AppearanceCharacteristics
extends PdfObjectWrapper<PdfDictionary> {
    public static AppearanceCharacteristics wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new AppearanceCharacteristics(baseObject) : null;
    }

    public AppearanceCharacteristics(Document context) {
        super(context, new PdfDictionary());
    }

    private AppearanceCharacteristics(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public AppearanceCharacteristics clone(Document context) {
        return (AppearanceCharacteristics)super.clone(context);
    }

    public String getAlternateCaption() {
        PdfTextString alternateCaptionObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.AC);
        return alternateCaptionObject != null ? alternateCaptionObject.getValue() : null;
    }

    public FormXObject getAlternateIcon() {
        return FormXObject.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.IX));
    }

    public DeviceColor getBackgroundColor() {
        return this.getColor(PdfName.BG);
    }

    public DeviceColor getBorderColor() {
        return this.getColor(PdfName.BC);
    }

    public CaptionPositionEnum getCaptionPosition() {
        PdfInteger captionPositionObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.TP);
        return captionPositionObject != null ? CaptionPositionEnum.get((Integer)captionPositionObject.getRawValue()) : CaptionPositionEnum.CaptionOnly;
    }

    public IconFitObject getIconFit() {
        PdfDirectObject iconFitObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.IF);
        return iconFitObject != null ? new IconFitObject(iconFitObject) : null;
    }

    public String getNormalCaption() {
        PdfTextString normalCaptionObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.CA);
        return normalCaptionObject != null ? normalCaptionObject.getValue() : null;
    }

    public FormXObject getNormalIcon() {
        return FormXObject.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.I));
    }

    public OrientationEnum getOrientation() {
        PdfInteger orientationObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.R);
        return orientationObject != null ? OrientationEnum.get((Integer)orientationObject.getRawValue()) : OrientationEnum.Up;
    }

    public String getRolloverCaption() {
        PdfTextString rolloverCaptionObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RC);
        return rolloverCaptionObject != null ? rolloverCaptionObject.getValue() : null;
    }

    public FormXObject getRolloverIcon() {
        return FormXObject.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.RI));
    }

    public void setAlternateCaption(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AC, new PdfTextString(value));
    }

    public void setAlternateIcon(FormXObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.IX, value.getBaseObject());
    }

    public void setBackgroundColor(DeviceColor value) {
        this.setColor(PdfName.BG, value);
    }

    public void setBorderColor(DeviceColor value) {
        this.setColor(PdfName.BC, value);
    }

    public void setCaptionPosition(CaptionPositionEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.TP, PdfInteger.get(value.getCode()));
    }

    public void setIconFit(IconFitObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.IF, PdfObjectWrapper.getBaseObject(value));
    }

    public void setNormalCaption(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CA, PdfTextString.get(value));
    }

    public void setNormalIcon(FormXObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.I, PdfObjectWrapper.getBaseObject(value));
    }

    public void setOrientation(OrientationEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.R, PdfInteger.get(value.getCode()));
    }

    public void setRolloverCaption(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RC, PdfTextString.get(value));
    }

    public void setRolloverIcon(FormXObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RI, PdfObjectWrapper.getBaseObject(value));
    }

    private DeviceColor getColor(PdfName key) {
        return DeviceColor.get((PdfArray)((PdfDictionary)this.getBaseDataObject()).resolve(key));
    }

    private void setColor(PdfName key, DeviceColor value) {
        ((PdfDictionary)this.getBaseDataObject()).put(key, PdfObjectWrapper.getBaseObject(value));
    }

    public static enum CaptionPositionEnum {
        CaptionOnly(0),
        NoCaption(1),
        Below(2),
        Above(3),
        Right(4),
        Left(5),
        Overlaid(6);

        private final int code;

        public static CaptionPositionEnum get(int value) {
            CaptionPositionEnum[] captionPositionEnumArray = CaptionPositionEnum.values();
            int n = captionPositionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                CaptionPositionEnum position = captionPositionEnumArray[n2];
                if (position.getCode() == value) {
                    return position;
                }
                ++n2;
            }
            return null;
        }

        private CaptionPositionEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class IconFitObject
    extends PdfObjectWrapper<PdfDictionary> {
        public IconFitObject(Document context) {
            super(context, new PdfDictionary());
        }

        IconFitObject(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public IconFitObject clone(Document context) {
            return (IconFitObject)super.clone(context);
        }

        public ScaleModeEnum getScaleMode() {
            PdfName scaleModeObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.SW);
            if (scaleModeObject == null) {
                return ScaleModeEnum.Always;
            }
            return ScaleModeEnum.get(scaleModeObject);
        }

        public ScaleTypeEnum getScaleType() {
            PdfName scaleTypeObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S);
            if (scaleTypeObject == null) {
                return ScaleTypeEnum.Proportional;
            }
            return ScaleTypeEnum.get(scaleTypeObject);
        }

        public XAlignmentEnum getXAlignment() {
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                return XAlignmentEnum.Center;
            }
            switch ((int)Math.round(((PdfNumber)alignmentObject.get(0)).getDoubleValue() / 0.5)) {
                case 0: {
                    return XAlignmentEnum.Left;
                }
                case 2: {
                    return XAlignmentEnum.Right;
                }
            }
            return XAlignmentEnum.Center;
        }

        public YAlignmentEnum getYAlignment() {
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                return YAlignmentEnum.Middle;
            }
            switch ((int)Math.round(((PdfNumber)alignmentObject.get(1)).getDoubleValue() / 0.5)) {
                case 0: {
                    return YAlignmentEnum.Bottom;
                }
                case 2: {
                    return YAlignmentEnum.Top;
                }
            }
            return YAlignmentEnum.Middle;
        }

        public boolean isBorderExcluded() {
            PdfBoolean borderExcludedObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.FB);
            return borderExcludedObject != null ? borderExcludedObject.getValue() : false;
        }

        public void setBorderExcluded(boolean value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.FB, PdfBoolean.get(value));
        }

        public void setScaleMode(ScaleModeEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.SW, value.getCode());
        }

        public void setScaleType(ScaleTypeEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, value.getCode());
        }

        public void setXAlignment(XAlignmentEnum value) {
            double objectValue;
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                alignmentObject = new PdfArray(PdfReal.get(0.5), PdfReal.get(0.5));
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, alignmentObject);
            }
            switch (value) {
                case Left: {
                    objectValue = 0.0;
                    break;
                }
                case Right: {
                    objectValue = 1.0;
                    break;
                }
                default: {
                    objectValue = 0.5;
                }
            }
            alignmentObject.set(0, PdfReal.get(objectValue));
        }

        public void setYAlignment(YAlignmentEnum value) {
            double objectValue;
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                alignmentObject = new PdfArray(PdfReal.get(0.5), PdfReal.get(0.5));
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, alignmentObject);
            }
            switch (value) {
                case Bottom: {
                    objectValue = 0.0;
                    break;
                }
                case Top: {
                    objectValue = 1.0;
                    break;
                }
                default: {
                    objectValue = 0.5;
                }
            }
            alignmentObject.set(1, PdfReal.get(objectValue));
        }

        public static enum ScaleModeEnum {
            Always(PdfName.A),
            Bigger(PdfName.B),
            Smaller(PdfName.S),
            Never(PdfName.N);

            private final PdfName code;

            public static ScaleModeEnum get(PdfName value) {
                ScaleModeEnum[] scaleModeEnumArray = ScaleModeEnum.values();
                int n = scaleModeEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ScaleModeEnum mode = scaleModeEnumArray[n2];
                    if (mode.getCode().equals(value)) {
                        return mode;
                    }
                    ++n2;
                }
                return null;
            }

            private ScaleModeEnum(PdfName code) {
                this.code = code;
            }

            public PdfName getCode() {
                return this.code;
            }
        }

        public static enum ScaleTypeEnum {
            Anamorphic(PdfName.A),
            Proportional(PdfName.P);

            private final PdfName code;

            public static ScaleTypeEnum get(PdfName value) {
                ScaleTypeEnum[] scaleTypeEnumArray = ScaleTypeEnum.values();
                int n = scaleTypeEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ScaleTypeEnum mode = scaleTypeEnumArray[n2];
                    if (mode.getCode().equals(value)) {
                        return mode;
                    }
                    ++n2;
                }
                return null;
            }

            private ScaleTypeEnum(PdfName code) {
                this.code = code;
            }

            public PdfName getCode() {
                return this.code;
            }
        }
    }

    public static enum OrientationEnum {
        Up(0),
        Left(90),
        Down(180),
        Right(270);

        private final int code;

        public static OrientationEnum get(int value) {
            value = value % 360 - value % 90;
            OrientationEnum[] orientationEnumArray = OrientationEnum.values();
            int n = orientationEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrientationEnum orientation = orientationEnumArray[n2];
                if (orientation.getCode() == value) {
                    return orientation;
                }
                ++n2;
            }
            return null;
        }

        private OrientationEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

