/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import java.util.EnumSet;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.files.FileSpecification;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.actions.OptionsEnum;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfString;

@PDF(value=VersionEnum.PDF11)
public final class Launch
extends Action {
    public Launch(Document context, PdfObjectWrapper<?> target) {
        super(context, PdfName.Launch);
        this.setTarget(target);
    }

    Launch(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Launch clone(Document context) {
        return (Launch)super.clone(context);
    }

    public EnumSet<OptionsEnum> getOptions() {
        EnumSet<OptionsEnum> options = EnumSet.noneOf(OptionsEnum.class);
        PdfDirectObject optionObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.NewWindow);
        if (optionObject != null && ((PdfBoolean)optionObject).getValue().booleanValue()) {
            options.add(OptionsEnum.NewWindow);
        }
        return options;
    }

    public PdfObjectWrapper<?> getTarget() {
        PdfDirectObject targetObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.F);
        if (targetObject != null) {
            return FileSpecification.wrap(targetObject);
        }
        targetObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Win);
        if (targetObject != null) {
            return new WinTarget(targetObject);
        }
        return null;
    }

    public void setOptions(EnumSet<OptionsEnum> value) {
        if (value.contains((Object)OptionsEnum.NewWindow)) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.NewWindow, PdfBoolean.True);
        } else if (value.contains((Object)OptionsEnum.SameWindow)) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.NewWindow, PdfBoolean.False);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.NewWindow);
        }
    }

    public void setTarget(PdfObjectWrapper<?> value) {
        if (value instanceof FileSpecification) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, ((FileSpecification)value).getBaseObject());
        } else if (value instanceof WinTarget) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Win, ((WinTarget)value).getBaseObject());
        } else {
            throw new IllegalArgumentException("MUST be either FileSpecification or WinTarget");
        }
    }

    public static class WinTarget
    extends PdfObjectWrapper<PdfDictionary> {
        public WinTarget(Document context, String fileName) {
            super(context, new PdfDictionary());
            this.setFileName(fileName);
        }

        public WinTarget(Document context, String fileName, OperationEnum operation) {
            this(context, fileName);
            this.setOperation(operation);
        }

        public WinTarget(Document context, String fileName, String parameterString) {
            this(context, fileName);
            this.setParameterString(parameterString);
        }

        private WinTarget(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public WinTarget clone(Document context) {
            return (WinTarget)super.clone(context);
        }

        public String getDefaultDirectory() {
            PdfString defaultDirectoryObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
            return defaultDirectoryObject != null ? (String)defaultDirectoryObject.getValue() : null;
        }

        public String getFileName() {
            return (String)((PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.F)).getValue();
        }

        public OperationEnum getOperation() {
            PdfString operationObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.O);
            return operationObject != null ? OperationEnum.get(operationObject) : OperationEnum.Open;
        }

        public String getParameterString() {
            PdfString parameterStringObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.P);
            return parameterStringObject != null ? (String)parameterStringObject.getValue() : null;
        }

        public void setDefaultDirectory(String value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, new PdfString(value));
        }

        public void setFileName(String value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, new PdfString(value));
        }

        public void setOperation(OperationEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.O, value.getCode());
        }

        public void setParameterString(String value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, new PdfString(value));
        }

        public static enum OperationEnum {
            Open(new PdfString("open")),
            Print(new PdfString("print"));

            private final PdfString code;

            public static OperationEnum get(PdfString value) {
                OperationEnum[] operationEnumArray = OperationEnum.values();
                int n = operationEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OperationEnum operation = operationEnumArray[n2];
                    if (operation.getCode().equals(value)) {
                        return operation;
                    }
                    ++n2;
                }
                return null;
            }

            private OperationEnum(PdfString code) {
                this.code = code;
            }

            public PdfString getCode() {
                return this.code;
            }
        }
    }
}

