/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.IBuffer;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.objects.IPdfNamedObjectWrapper;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF13)
public final class JavaScript
extends Action
implements IPdfNamedObjectWrapper {
    static String getScript(PdfDictionary baseDataObject, PdfName key) {
        PdfDataObject scriptObject = baseDataObject.resolve(key);
        if (scriptObject == null) {
            return null;
        }
        if (scriptObject instanceof PdfTextString) {
            return ((PdfTextString)scriptObject).getValue();
        }
        IBuffer scriptBuffer = ((PdfStream)scriptObject).getBody();
        return scriptBuffer.getString(0, (int)scriptBuffer.getLength());
    }

    static void setScript(PdfDictionary baseDataObject, PdfName key, String value) {
        PdfDataObject scriptObject = baseDataObject.resolve(key);
        if (!(scriptObject instanceof PdfStream) && value.length() > 256) {
            scriptObject = new PdfStream();
            baseDataObject.put(key, baseDataObject.getFile().register(scriptObject));
        }
        if (scriptObject instanceof PdfStream) {
            IBuffer scriptBuffer = ((PdfStream)scriptObject).getBody();
            scriptBuffer.setLength(0);
            scriptBuffer.append(value);
        } else {
            baseDataObject.put(key, new PdfTextString(value));
        }
    }

    public JavaScript(Document context, String script) {
        super(context, PdfName.JavaScript);
        this.setScript(script);
    }

    JavaScript(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public JavaScript clone(Document context) {
        return (JavaScript)super.clone(context);
    }

    public String getScript() {
        return JavaScript.getScript((PdfDictionary)this.getBaseDataObject(), PdfName.JS);
    }

    public void setScript(String value) {
        JavaScript.setScript((PdfDictionary)this.getBaseDataObject(), PdfName.JS, value);
    }

    @Override
    public PdfString getName() {
        return this.retrieveName();
    }

    @Override
    public PdfDirectObject getNamedBaseObject() {
        return this.retrieveNamedBaseObject();
    }
}

