/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.actions.ChainedActions;
import org.pdfclown.documents.interaction.actions.DoTransition;
import org.pdfclown.documents.interaction.actions.GoTo3dView;
import org.pdfclown.documents.interaction.actions.GoToEmbedded;
import org.pdfclown.documents.interaction.actions.GoToFirstPage;
import org.pdfclown.documents.interaction.actions.GoToLastPage;
import org.pdfclown.documents.interaction.actions.GoToLocal;
import org.pdfclown.documents.interaction.actions.GoToNextPage;
import org.pdfclown.documents.interaction.actions.GoToPreviousPage;
import org.pdfclown.documents.interaction.actions.GoToRemote;
import org.pdfclown.documents.interaction.actions.GoToThread;
import org.pdfclown.documents.interaction.actions.GoToURI;
import org.pdfclown.documents.interaction.actions.ImportData;
import org.pdfclown.documents.interaction.actions.JavaScript;
import org.pdfclown.documents.interaction.actions.Launch;
import org.pdfclown.documents.interaction.actions.NamedAction;
import org.pdfclown.documents.interaction.actions.PlayMovie;
import org.pdfclown.documents.interaction.actions.PlaySound;
import org.pdfclown.documents.interaction.actions.Render;
import org.pdfclown.documents.interaction.actions.ResetForm;
import org.pdfclown.documents.interaction.actions.SetLayerState;
import org.pdfclown.documents.interaction.actions.SubmitForm;
import org.pdfclown.documents.interaction.actions.ToggleVisibility;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;

@PDF(value=VersionEnum.PDF11)
public class Action
extends PdfObjectWrapper<PdfDictionary> {
    public static final Action wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfDictionary dataObject = (PdfDictionary)baseObject.resolve();
        PdfName actionType = (PdfName)dataObject.get(PdfName.S);
        if (actionType == null || dataObject.containsKey(PdfName.Type) && !dataObject.get(PdfName.Type).equals(PdfName.Action)) {
            return null;
        }
        if (actionType.equals(PdfName.GoTo)) {
            return new GoToLocal(baseObject);
        }
        if (actionType.equals(PdfName.GoToR)) {
            return new GoToRemote(baseObject);
        }
        if (actionType.equals(PdfName.GoToE)) {
            return new GoToEmbedded(baseObject);
        }
        if (actionType.equals(PdfName.Launch)) {
            return new Launch(baseObject);
        }
        if (actionType.equals(PdfName.Thread)) {
            return new GoToThread(baseObject);
        }
        if (actionType.equals(PdfName.URI)) {
            return new GoToURI(baseObject);
        }
        if (actionType.equals(PdfName.Sound)) {
            return new PlaySound(baseObject);
        }
        if (actionType.equals(PdfName.Movie)) {
            return new PlayMovie(baseObject);
        }
        if (actionType.equals(PdfName.Hide)) {
            return new ToggleVisibility(baseObject);
        }
        if (actionType.equals(PdfName.Named)) {
            PdfName actionName = (PdfName)dataObject.get(PdfName.N);
            if (actionName.equals(PdfName.NextPage)) {
                return new GoToNextPage(baseObject);
            }
            if (actionName.equals(PdfName.PrevPage)) {
                return new GoToPreviousPage(baseObject);
            }
            if (actionName.equals(PdfName.FirstPage)) {
                return new GoToFirstPage(baseObject);
            }
            if (actionName.equals(PdfName.LastPage)) {
                return new GoToLastPage(baseObject);
            }
            return new NamedAction(baseObject);
        }
        if (actionType.equals(PdfName.SubmitForm)) {
            return new SubmitForm(baseObject);
        }
        if (actionType.equals(PdfName.ResetForm)) {
            return new ResetForm(baseObject);
        }
        if (actionType.equals(PdfName.ImportData)) {
            return new ImportData(baseObject);
        }
        if (actionType.equals(PdfName.JavaScript)) {
            return new JavaScript(baseObject);
        }
        if (actionType.equals(PdfName.SetOCGState)) {
            return new SetLayerState(baseObject);
        }
        if (actionType.equals(PdfName.Rendition)) {
            return new Render(baseObject);
        }
        if (actionType.equals(PdfName.Trans)) {
            return new DoTransition(baseObject);
        }
        if (actionType.equals(PdfName.GoTo3DView)) {
            return new GoTo3dView(baseObject);
        }
        return new Action(baseObject);
    }

    protected Action(Document context, PdfName actionType) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.S}, new PdfDirectObject[]{PdfName.Action, actionType}));
    }

    protected Action(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Action clone(Document context) {
        return (Action)super.clone(context);
    }

    @PDF(value=VersionEnum.PDF12)
    public ChainedActions getActions() {
        PdfDirectObject nextObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Next);
        return nextObject != null ? new ChainedActions(nextObject, this) : null;
    }

    public void setActions(ChainedActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Next, value.getBaseObject());
    }
}

