/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.functions.Type0Function;
import org.pdfclown.documents.functions.Type2Function;
import org.pdfclown.documents.functions.Type3Function;
import org.pdfclown.documents.functions.Type4Function;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.math.Interval;

@PDF(value=VersionEnum.PDF12)
public abstract class Function<TDataObject extends PdfDataObject>
extends PdfObjectWrapper<TDataObject> {
    private static final int FunctionType0 = 0;
    private static final int FunctionType2 = 2;
    private static final int FunctionType3 = 3;
    private static final int FunctionType4 = 4;

    public static final Function<?> wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfDataObject dataObject = baseObject.resolve();
        PdfDictionary dictionary = Function.getDictionary(dataObject);
        int functionType = (Integer)((PdfInteger)dictionary.get(PdfName.FunctionType)).getRawValue();
        switch (functionType) {
            case 0: {
                return new Type0Function(baseObject);
            }
            case 2: {
                return new Type2Function(baseObject);
            }
            case 3: {
                return new Type3Function(baseObject);
            }
            case 4: {
                return new Type4Function(baseObject);
            }
        }
        throw new UnsupportedOperationException("Function type " + functionType + " unknown.");
    }

    private static final PdfDictionary getDictionary(PdfDataObject functionDataObject) {
        if (functionDataObject instanceof PdfDictionary) {
            return (PdfDictionary)functionDataObject;
        }
        return ((PdfStream)functionDataObject).getHeader();
    }

    protected Function(Document context, TDataObject baseDataObject) {
        super(context, baseDataObject);
    }

    protected Function(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public abstract double[] calculate(double[] var1);

    public final List<PdfDirectObject> calculate(List<PdfDirectObject> inputs) {
        ArrayList<PdfDirectObject> outputs = new ArrayList<PdfDirectObject>();
        double[] inputValues = new double[inputs.size()];
        int index = 0;
        int length = inputValues.length;
        while (index < length) {
            inputValues[index] = ((PdfNumber)inputs.get(index)).getDoubleValue();
            ++index;
        }
        double[] outputValues = this.calculate(inputValues);
        int index2 = 0;
        int length2 = outputValues.length;
        while (index2 < length2) {
            outputs.add(PdfReal.get(outputValues[index2]));
            ++index2;
        }
        return outputs;
    }

    public List<Interval<Double>> getDomains() {
        return this.getIntervals(PdfName.Domain, null);
    }

    public int getInputCount() {
        return ((PdfArray)this.getDictionary().get(PdfName.Domain)).size() / 2;
    }

    public int getOutputCount() {
        PdfArray rangesObject = (PdfArray)this.getDictionary().get(PdfName.Range);
        return rangesObject == null ? 1 : rangesObject.size() / 2;
    }

    public List<Interval<Double>> getRanges() {
        return this.getIntervals(PdfName.Range, null);
    }

    protected final PdfDictionary getDictionary() {
        return Function.getDictionary(this.getBaseDataObject());
    }

    protected final <T extends Comparable<T>> List<Interval<T>> getIntervals(PdfName key, IDefaultIntervalsCallback<T> defaultIntervalsCallback) {
        ArrayList<Interval<T>> intervals;
        PdfArray intervalsObject = (PdfArray)this.getDictionary().get(key);
        if (intervalsObject == null) {
            intervals = defaultIntervalsCallback == null ? null : defaultIntervalsCallback.invoke(new ArrayList());
        } else {
            intervals = new ArrayList<Interval<T>>();
            Iterator<PdfDirectObject> intervalsObjectIterator = intervalsObject.iterator();
            while (intervalsObjectIterator.hasNext()) {
                intervals.add(new Interval<Comparable>((Comparable)((Object)((PdfNumber)intervalsObjectIterator.next()).getValue()), (Comparable)((Object)((PdfNumber)intervalsObjectIterator.next()).getValue())));
            }
        }
        return intervals;
    }

    protected static interface IDefaultIntervalsCallback<T extends Comparable<T>> {
        public List<Interval<T>> invoke(List<Interval<T>> var1);
    }
}

