/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.files;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.FileInputStream;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.bytes.OutputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.files.EmbeddedFile;
import org.pdfclown.documents.files.FullFileSpecification;
import org.pdfclown.documents.files.SimpleFileSpecification;
import org.pdfclown.objects.IPdfNamedObjectWrapper;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfString;

@PDF(value=VersionEnum.PDF11)
public abstract class FileSpecification<TDataObject extends PdfDirectObject>
extends PdfObjectWrapper<TDataObject>
implements IPdfNamedObjectWrapper {
    public static SimpleFileSpecification get(Document context, String path) {
        return (SimpleFileSpecification)FileSpecification.get(context, path, false);
    }

    public static FileSpecification<?> get(Document context, String path, boolean full) {
        return full ? new FullFileSpecification(context, path) : new SimpleFileSpecification(context, path);
    }

    public static FullFileSpecification get(EmbeddedFile embeddedFile, String filename) {
        return new FullFileSpecification(embeddedFile, filename);
    }

    public static FullFileSpecification get(Document context, URL url) {
        return new FullFileSpecification(context, url);
    }

    public static FileSpecification<?> wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfDataObject baseDataObject = baseObject.resolve();
        if (baseDataObject instanceof PdfString) {
            return new SimpleFileSpecification(baseObject);
        }
        if (baseDataObject instanceof PdfDictionary) {
            return new FullFileSpecification(baseObject);
        }
        return null;
    }

    protected FileSpecification(Document context, TDataObject baseDataObject) {
        super(context, baseDataObject);
    }

    protected FileSpecification(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public String getAbsolutePath() {
        String basePath;
        File file = new File(this.getPath());
        if (!file.isAbsolute() && (basePath = this.getDocument().getFile().getPath()) != null) {
            File baseFile = new File(basePath);
            file = new File(baseFile.isFile() ? baseFile.getParentFile() : baseFile, file.getPath());
        }
        return file.getAbsolutePath();
    }

    public IInputStream getInputStream() {
        try {
            return new FileInputStream(new RandomAccessFile(this.getAbsolutePath(), "r"));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public IOutputStream getOutputStream() {
        try {
            return new OutputStream(new BufferedOutputStream(new FileOutputStream(this.getAbsolutePath())));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String getPath();

    @Override
    public PdfString getName() {
        return this.retrieveName();
    }

    @Override
    public PdfDirectObject getNamedBaseObject() {
        return this.retrieveNamedBaseObject();
    }
}

