/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.objects.ShowText;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfString;

@PDF(value=VersionEnum.PDF10)
public final class ShowTextToNextLine
extends ShowText {
    public static final String SimpleOperator = "'";
    public static final String SpaceOperator = "''";

    public ShowTextToNextLine(byte[] text) {
        super(SimpleOperator, new PdfDirectObject[]{new PdfString(text)});
    }

    public ShowTextToNextLine(byte[] text, double wordSpace, double charSpace) {
        super(SpaceOperator, PdfReal.get(wordSpace), PdfReal.get(charSpace), new PdfString(text));
    }

    public ShowTextToNextLine(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    public Double getCharSpace() {
        if (this.operator.equals(SimpleOperator)) {
            return null;
        }
        return ((PdfNumber)this.operands.get(1)).getDoubleValue();
    }

    @Override
    public byte[] getText() {
        return (byte[])((PdfString)this.operands.get(this.operator.equals(SimpleOperator) ? 0 : 2)).getRawValue();
    }

    public Double getWordSpace() {
        if (this.operator.equals(SimpleOperator)) {
            return null;
        }
        return ((PdfNumber)this.operands.get(0)).getDoubleValue();
    }

    public void setCharSpace(Double value) {
        this.ensureSpaceOperation();
        this.operands.set(1, PdfReal.get(value));
    }

    @Override
    public void setText(byte[] value) {
        this.operands.set(this.operator.equals(SimpleOperator) ? 0 : 2, new PdfString(value));
    }

    public void setWordSpace(Double value) {
        this.ensureSpaceOperation();
        this.operands.set(0, PdfReal.get(value));
    }

    private void ensureSpaceOperation() {
        if (this.operator.equals(SimpleOperator)) {
            this.operator = SpaceOperator;
            this.operands.add(0, PdfReal.get(0));
            this.operands.add(1, PdfReal.get(0));
        }
    }
}

