/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.documents.contents.objects.IResourceReference;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF10)
public final class SetFont
extends Operation
implements IResourceReference<Font> {
    public static final String Operator = "Tf";

    public SetFont(PdfName name, double size) {
        super(Operator, name, PdfReal.get(size));
    }

    public SetFont(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    public Font getFont(IContentContext context) {
        return this.getResource(context);
    }

    public double getSize() {
        return ((PdfNumber)this.operands.get(1)).getDoubleValue();
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        state.setFont(this.getFont(state.getScanner().getContentContext()));
        state.setFontSize(this.getSize());
    }

    public void setSize(double value) {
        this.operands.set(1, PdfReal.get(value));
    }

    @Override
    public PdfName getName() {
        return (PdfName)this.operands.get(0);
    }

    @Override
    public Font getResource(IContentContext context) {
        return (Font)context.getResources().getFonts().get(this.getName());
    }

    @Override
    public void setName(PdfName value) {
        this.operands.set(0, value);
    }
}

