/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.LineDash;
import org.pdfclown.documents.contents.WindModeEnum;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.util.ConvertUtils;

@PDF(value=VersionEnum.PDF10)
public final class PaintPath
extends Operation {
    public static final String CloseFillStrokeEvenOddOperator = "b*";
    public static final String CloseFillStrokeOperator = "b";
    public static final String CloseStrokeOperator = "s";
    public static final String EndPathNoOpOperator = "n";
    public static final String FillEvenOddOperator = "f*";
    public static final String FillObsoleteOperator = "F";
    public static final String FillOperator = "f";
    public static final String FillStrokeEvenOddOperator = "B*";
    public static final String FillStrokeOperator = "B";
    public static final String StrokeOperator = "S";
    public static final PaintPath CloseFillStroke = new PaintPath("b", true, true, true, WindModeEnum.NonZero);
    public static final PaintPath CloseFillStrokeEvenOdd = new PaintPath("b*", true, true, true, WindModeEnum.EvenOdd);
    public static final PaintPath CloseStroke = new PaintPath("s", true, true, false, null);
    public static final PaintPath EndPathNoOp = new PaintPath("n", false, false, false, null);
    public static final PaintPath Fill = new PaintPath("f", false, false, true, WindModeEnum.NonZero);
    public static final PaintPath FillEvenOdd = new PaintPath("f*", false, false, true, WindModeEnum.EvenOdd);
    public static final PaintPath FillStroke = new PaintPath("B", false, true, true, WindModeEnum.NonZero);
    public static final PaintPath FillStrokeEvenOdd = new PaintPath("B*", false, true, true, WindModeEnum.EvenOdd);
    public static final PaintPath Stroke = new PaintPath("S", false, true, false, null);
    private final boolean closed;
    private final boolean filled;
    private final WindModeEnum fillMode;
    private final boolean stroked;

    private static Stroke getStroke(ContentScanner.GraphicsState state) {
        LineDash lineDash = state.getLineDash();
        double[] dashArray = lineDash.getDashArray();
        return new BasicStroke((float)state.getLineWidth(), state.getLineCap().toAwt(), state.getLineJoin().toAwt(), (float)state.getMiterLimit(), dashArray != null && dashArray.length > 0 ? ConvertUtils.toFloatArray(dashArray) : null, (float)lineDash.getDashPhase());
    }

    private PaintPath(String operator, boolean closed, boolean stroked, boolean filled, WindModeEnum fillMode) {
        super(operator);
        this.closed = closed;
        this.stroked = stroked;
        this.filled = filled;
        this.fillMode = fillMode;
    }

    public WindModeEnum getFillMode() {
        return this.fillMode;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public boolean isStroked() {
        return this.stroked;
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        ContentScanner scanner = state.getScanner();
        Path2D pathObject = (Path2D)scanner.getRenderObject();
        if (pathObject != null) {
            Graphics2D context = scanner.getRenderContext();
            if (this.closed) {
                pathObject.closePath();
            }
            if (this.filled) {
                context.setPaint(state.getFillColorSpace().getPaint(state.getFillColor()));
                pathObject.setWindingRule(this.fillMode.toAwt());
                context.fill(pathObject);
            }
            if (this.stroked) {
                context.setPaint(state.getStrokeColorSpace().getPaint(state.getStrokeColor()));
                context.fill(new Path2D.Double(PaintPath.getStroke(state).createStrokedShape(pathObject)));
            }
        }
    }
}

