/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.geom.Path2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.WindModeEnum;
import org.pdfclown.documents.contents.objects.Operation;

@PDF(value=VersionEnum.PDF10)
public final class ModifyClipPath
extends Operation {
    public static final String EvenOddOperator = "W*";
    public static final String NonZeroOperator = "W";
    public static final ModifyClipPath EvenOdd = new ModifyClipPath("W*", WindModeEnum.EvenOdd);
    public static final ModifyClipPath NonZero = new ModifyClipPath("W", WindModeEnum.NonZero);
    private WindModeEnum clipMode;

    private ModifyClipPath(String operator, WindModeEnum clipMode) {
        super(operator);
        this.clipMode = clipMode;
    }

    public WindModeEnum getClipMode() {
        return this.clipMode;
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        ContentScanner scanner = state.getScanner();
        Path2D pathObject = (Path2D)scanner.getRenderObject();
        if (pathObject != null) {
            pathObject.setWindingRule(this.clipMode.toAwt());
            scanner.getRenderContext().clip(pathObject);
        }
    }
}

