/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF10)
public final class DrawLine
extends Operation {
    public static final String Operator = "l";

    public DrawLine(Point2D point) {
        this(point.getX(), point.getY());
    }

    public DrawLine(double pointX, double pointY) {
        super(Operator, PdfReal.get(pointX), PdfReal.get(pointY));
    }

    public DrawLine(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    public Point2D getPoint() {
        return new Point2D.Double(((PdfNumber)this.operands.get(0)).getDoubleValue(), ((PdfNumber)this.operands.get(1)).getDoubleValue());
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        Path2D pathObject = (Path2D)state.getScanner().getRenderObject();
        if (pathObject != null) {
            Point2D point = this.getPoint();
            pathObject.lineTo(point.getX(), point.getY());
        }
    }

    public void setPoint(Point2D value) {
        this.operands.set(0, PdfReal.get(value.getX()));
        this.operands.set(1, PdfReal.get(value.getY()));
    }
}

