/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.PropertyList;
import org.pdfclown.documents.contents.objects.IResourceReference;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF12)
public abstract class ContentMarker
extends Operation
implements IResourceReference<PropertyList> {
    protected ContentMarker(PdfName tag) {
        this(tag, null);
    }

    protected ContentMarker(PdfName tag, PdfDirectObject properties) {
        super((String)null, (PdfDirectObject)tag);
        if (properties != null) {
            this.operands.add(properties);
            this.operator = this.getPropertyListOperator();
        } else {
            this.operator = this.getSimpleOperator();
        }
    }

    protected ContentMarker(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    public Object getProperties() {
        PdfDirectObject propertiesObject = (PdfDirectObject)this.operands.get(1);
        if (propertiesObject == null) {
            return null;
        }
        if (propertiesObject instanceof PdfName) {
            return propertiesObject;
        }
        if (propertiesObject instanceof PdfDictionary) {
            return PropertyList.wrap(propertiesObject);
        }
        throw new UnsupportedOperationException("Property list type unknown: " + propertiesObject.getClass().getName());
    }

    public PropertyList getProperties(IContentContext context) {
        Object properties = this.getProperties();
        return properties instanceof PdfName ? (PropertyList)context.getResources().getPropertyLists().get(properties) : (PropertyList)properties;
    }

    public PdfName getTag() {
        return (PdfName)this.operands.get(0);
    }

    public void setProperties(Object value) {
        if (value == null) {
            this.operator = this.getSimpleOperator();
            if (this.operands.size() > 1) {
                this.operands.remove(1);
            }
        } else {
            PdfDirectObject operand;
            if (value instanceof PdfName) {
                operand = (PdfName)value;
            } else if (value instanceof PropertyList) {
                operand = (PdfDirectObject)((PropertyList)value).getBaseDataObject();
            } else {
                throw new IllegalArgumentException("value MUST be a PdfName or a PropertyList.");
            }
            this.operator = this.getPropertyListOperator();
            if (this.operands.size() > 1) {
                this.operands.set(1, operand);
            } else {
                this.operands.add(operand);
            }
        }
    }

    public void setTag(PdfName value) {
        this.operands.set(0, value);
    }

    @Override
    public PdfName getName() {
        Object properties = this.getProperties();
        return properties instanceof PdfName ? (PdfName)properties : null;
    }

    @Override
    public PropertyList getResource(IContentContext context) {
        return this.getProperties(context);
    }

    @Override
    public void setName(PdfName value) {
        this.setProperties(value);
    }

    protected abstract String getPropertyListOperator();

    protected abstract String getSimpleOperator();
}

