/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.Operation;

@PDF(value=VersionEnum.PDF10)
public abstract class CompositeObject
extends ContentObject {
    protected List<ContentObject> objects;

    protected CompositeObject() {
        this.objects = new ArrayList<ContentObject>();
    }

    protected CompositeObject(ContentObject object) {
        this();
        this.objects.add(object);
    }

    protected CompositeObject(ContentObject ... objects) {
        this();
        ContentObject[] contentObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            ContentObject object = contentObjectArray[n2];
            this.objects.add(object);
            ++n2;
        }
    }

    protected CompositeObject(List<ContentObject> objects) {
        this.objects = objects;
    }

    public Operation getHeader() {
        return null;
    }

    public List<ContentObject> getObjects() {
        return this.objects;
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        ContentScanner childLevel = state.getScanner().getChildLevel();
        if (!this.render(state)) {
            childLevel.moveEnd();
        }
        childLevel.getState().copyTo(state);
    }

    public void setHeader(Operation value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "{" + this.objects.toString() + "}";
    }

    @Override
    public void writeTo(IOutputStream stream, Document context) {
        for (ContentObject object : this.objects) {
            object.writeTo(stream, context);
        }
    }

    protected Shape createRenderObject() {
        return null;
    }

    protected boolean render(ContentScanner.GraphicsState state) {
        ContentScanner scanner = state.getScanner();
        Graphics2D context = scanner.getRenderContext();
        if (context == null) {
            return false;
        }
        scanner.getChildLevel().render(context, scanner.getCanvasSize(), this.createRenderObject());
        return true;
    }
}

