/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.layers;

import java.util.List;
import java.util.ListIterator;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.layers.ILayerNode;
import org.pdfclown.documents.contents.layers.Layer;
import org.pdfclown.documents.contents.layers.LayerNode;
import org.pdfclown.objects.Array;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF15)
public final class Layers
extends Array<ILayerNode>
implements ILayerNode {
    private static final ItemWrapper Wrapper = new ItemWrapper();

    public static Layers wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new Layers(baseObject) : null;
    }

    public Layers(Document context) {
        this(context, (String)null);
    }

    public Layers(Document context, String title) {
        super(context, Wrapper);
        this.setTitle(title);
    }

    private Layers(PdfDirectObject baseObject) {
        super(Wrapper, baseObject);
    }

    @Override
    public Layers clone(Document context) {
        return (Layers)super.clone(context);
    }

    @Override
    public void add(int index, ILayerNode item) {
        super.add(this.getBaseIndex(index), item);
    }

    @Override
    public ILayerNode get(int index) {
        return (ILayerNode)super.get(this.getBaseIndex(index));
    }

    @Override
    public int indexOf(Object item) {
        return this.getNodeIndex(super.indexOf(item));
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.getNodeIndex(super.lastIndexOf(item));
    }

    @Override
    public ListIterator<ILayerNode> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<ILayerNode> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public ILayerNode remove(int index) {
        int baseIndex = this.getBaseIndex(index);
        ILayerNode removedItem = (ILayerNode)super.remove(baseIndex);
        if (removedItem instanceof Layer && baseIndex < super.size() && ((PdfArray)this.getBaseDataObject()).resolve(baseIndex) instanceof PdfArray) {
            ((PdfArray)this.getBaseDataObject()).remove(baseIndex);
        }
        return removedItem;
    }

    @Override
    public ILayerNode set(int index, ILayerNode item) {
        return super.set(this.getBaseIndex(index), item);
    }

    @Override
    public int size() {
        return this.evaluate(new INodeEvaluator(){

            @Override
            public int evaluate(int currentNodeIndex, int currentBaseIndex) {
                if (currentBaseIndex == -1) {
                    return currentNodeIndex;
                }
                return -1;
            }
        }) + 1;
    }

    @Override
    public List<ILayerNode> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public Object[] toArray() {
        throw new NotImplementedException();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        throw new NotImplementedException();
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public Layers getLayers() {
        return this;
    }

    @Override
    public String getTitle() {
        if (((PdfArray)this.getBaseDataObject()).isEmpty()) {
            return null;
        }
        PdfDirectObject firstObject = ((PdfArray)this.getBaseDataObject()).get(0);
        return firstObject instanceof PdfTextString ? ((PdfTextString)firstObject).getValue() : null;
    }

    @Override
    public void setTitle(String value) {
        PdfDirectObject firstObject;
        PdfTextString titleObject = PdfTextString.get(value);
        PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
        PdfDirectObject pdfDirectObject = firstObject = baseDataObject.isEmpty() ? null : baseDataObject.get(0);
        if (firstObject instanceof PdfTextString) {
            if (titleObject != null) {
                baseDataObject.set(0, titleObject);
            } else {
                baseDataObject.remove(0);
            }
        } else if (titleObject != null) {
            baseDataObject.add(0, titleObject);
        }
    }

    private int evaluate(INodeEvaluator evaluator) {
        PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
        int nodeIndex = -1;
        boolean groupAllowed = true;
        int baseIndex = 0;
        int baseLength = super.size();
        while (baseIndex < baseLength) {
            int evaluation;
            PdfDataObject itemDataObject = baseDataObject.resolve(baseIndex);
            if ((itemDataObject instanceof PdfDictionary || itemDataObject instanceof PdfArray && groupAllowed) && (evaluation = evaluator.evaluate(++nodeIndex, baseIndex)) > -1) {
                return evaluation;
            }
            groupAllowed = !(itemDataObject instanceof PdfDictionary);
            ++baseIndex;
        }
        return evaluator.evaluate(nodeIndex, -1);
    }

    private int getBaseIndex(final int nodeIndex) {
        return this.evaluate(new INodeEvaluator(){

            @Override
            public int evaluate(int currentNodeIndex, int currentBaseIndex) {
                if (currentNodeIndex == nodeIndex) {
                    return currentBaseIndex;
                }
                return -1;
            }
        });
    }

    private int getNodeIndex(final int baseIndex) {
        return this.evaluate(new INodeEvaluator(){

            @Override
            public int evaluate(int currentNodeIndex, int currentBaseIndex) {
                if (currentBaseIndex == baseIndex) {
                    return currentNodeIndex;
                }
                return -1;
            }
        });
    }

    private static interface INodeEvaluator {
        public int evaluate(int var1, int var2);
    }

    private static class ItemWrapper
    implements Array.IWrapper<ILayerNode> {
        private ItemWrapper() {
        }

        @Override
        public ILayerNode wrap(PdfDirectObject baseObject) {
            return LayerNode.wrap(baseObject);
        }
    }
}

