/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.layers;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.layers.ILayerConfiguration;
import org.pdfclown.documents.contents.layers.Layer;
import org.pdfclown.documents.contents.layers.LayerGroup;
import org.pdfclown.documents.contents.layers.Layers;
import org.pdfclown.documents.contents.layers.ListModeEnum;
import org.pdfclown.objects.Array;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF15)
public class LayerConfiguration
extends PdfObjectWrapper<PdfDictionary>
implements ILayerConfiguration {
    public LayerConfiguration(Document context) {
        super(context, new PdfDictionary());
    }

    public LayerConfiguration(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public LayerConfiguration clone(Document context) {
        return (LayerConfiguration)super.clone(context);
    }

    @Override
    public String getCreator() {
        return (String)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Creator));
    }

    @Override
    public Layers getLayers() {
        return Layers.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Order, PdfArray.class));
    }

    @Override
    public ListModeEnum getListMode() {
        return ListModeEnum.valueOf((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.ListMode));
    }

    @Override
    public Array<LayerGroup> getOptionGroups() {
        return Array.wrap(LayerGroup.class, ((PdfDictionary)this.getBaseDataObject()).get(PdfName.RBGroups, PdfArray.class));
    }

    @Override
    public String getTitle() {
        return (String)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name));
    }

    @Override
    public Boolean isVisible() {
        return BaseStateEnum.valueOf((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.BaseState)).isEnabled();
    }

    @Override
    public void setCreator(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Creator, PdfTextString.get(value));
    }

    @Override
    public void setLayers(Layers value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Order, value.getBaseObject());
    }

    @Override
    public void setListMode(ListModeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.ListMode, value.getName());
    }

    @Override
    public void setTitle(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, PdfTextString.get(value));
    }

    @Override
    public void setVisible(Boolean value) {
        if (!(this.getBaseObject().getParent() instanceof PdfDictionary)) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BaseState, BaseStateEnum.valueOf(value).getName());
        }
    }

    boolean isVisible(Layer layer) {
        Boolean defaultVisible = this.isVisible();
        if (defaultVisible == null || defaultVisible.booleanValue()) {
            return !this.getOffLayersObject().contains(layer.getBaseObject());
        }
        return this.getOnLayersObject().contains(layer.getBaseObject());
    }

    void setUsageApplication(PdfName event, PdfName category, Layer layer, boolean retain) {
        boolean matched = false;
        PdfArray usages = ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.AS, PdfArray.class);
        for (PdfDirectObject usage : usages) {
            PdfDictionary usageDictionary = (PdfDictionary)usage;
            if (!usageDictionary.get(PdfName.Event).equals(event) || !((PdfArray)usageDictionary.get(PdfName.Category)).contains(category)) continue;
            PdfArray usageLayers = usageDictionary.resolve(PdfName.OCGs, PdfArray.class);
            if (usageLayers.contains(layer.getBaseObject())) {
                if (!retain) {
                    usageLayers.remove(layer.getBaseObject());
                }
            } else if (retain) {
                usageLayers.add(layer.getBaseObject());
            }
            matched = true;
        }
        if (!matched && retain) {
            PdfDictionary usageDictionary = new PdfDictionary();
            usageDictionary.put(PdfName.Event, event);
            usageDictionary.resolve(PdfName.Category, PdfArray.class).add(category);
            usageDictionary.resolve(PdfName.OCGs, PdfArray.class).add(layer.getBaseObject());
            usages.add(usageDictionary);
        }
    }

    void setVisible(Layer layer, boolean value) {
        PdfDirectObject layerObject = layer.getBaseObject();
        PdfArray offLayersObject = this.getOffLayersObject();
        PdfArray onLayersObject = this.getOnLayersObject();
        Boolean defaultVisible = this.isVisible();
        if (defaultVisible == null) {
            if (value && !onLayersObject.contains(layerObject)) {
                onLayersObject.add(layerObject);
                offLayersObject.remove(layerObject);
            } else if (!value && !offLayersObject.contains(layerObject)) {
                offLayersObject.add(layerObject);
                onLayersObject.remove(layerObject);
            }
        } else if (!defaultVisible.booleanValue()) {
            if (value && !onLayersObject.contains(layerObject)) {
                onLayersObject.add(layerObject);
            }
        } else if (!value && !offLayersObject.contains(layerObject)) {
            offLayersObject.add(layerObject);
        }
    }

    private PdfArray getOffLayersObject() {
        return ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.OFF, PdfArray.class);
    }

    private PdfArray getOnLayersObject() {
        return ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.ON, PdfArray.class);
    }

    private static enum BaseStateEnum {
        On(PdfName.ON, true),
        Off(PdfName.OFF, false),
        Unchanged(PdfName.Unchanged, null);

        private PdfName name;
        private Boolean enabled;

        public static BaseStateEnum valueOf(Boolean enabled) {
            BaseStateEnum[] baseStateEnumArray = BaseStateEnum.values();
            int n = baseStateEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                BaseStateEnum value = baseStateEnumArray[n2];
                if (enabled != null && enabled.equals(value.isEnabled()) || enabled == value.isEnabled()) {
                    return value;
                }
                ++n2;
            }
            throw new UnsupportedOperationException();
        }

        private BaseStateEnum(PdfName name, Boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        public PdfName getName() {
            return this.name;
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        public static BaseStateEnum valueOf(String string) {
            return Enum.valueOf(BaseStateEnum.class, string);
        }
    }
}

