/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.util.Hashtable;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.documents.contents.fonts.GlyphMapping;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.util.ByteArray;

@PDF(value=VersionEnum.PDF10)
public abstract class SimpleFont
extends Font {
    protected SimpleFont(Document context) {
        super(context);
    }

    protected SimpleFont(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    protected PdfDictionary getDescriptor() {
        return (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.FontDescriptor);
    }

    protected abstract void loadEncoding();

    protected void loadEncodingDifferences(PdfDictionary encodingDictionary, Map<ByteArray, Integer> codes) {
        PdfArray differenceObjects = (PdfArray)encodingDictionary.resolve(PdfName.Differences);
        if (differenceObjects == null) {
            return;
        }
        byte[] charCodeData = new byte[1];
        for (PdfDirectObject differenceObject : differenceObjects) {
            if (differenceObject instanceof PdfInteger) {
                charCodeData[0] = (byte)(((PdfInteger)differenceObject).getValue() & 0xFF);
                continue;
            }
            ByteArray charCode = new ByteArray(charCodeData);
            String charName = ((PdfName)differenceObject).getValue();
            if (charName.equals(".notdef")) {
                codes.remove(charCode);
            } else {
                Integer code = GlyphMapping.nameToCode(charName);
                codes.put(charCode, code != null ? code : charCodeData[0]);
            }
            charCodeData[0] = (byte)(charCodeData[0] + 1);
        }
    }

    @Override
    protected void onLoad() {
        PdfDictionary descriptor;
        this.loadEncoding();
        if (this.glyphWidths == null) {
            this.glyphWidths = new Hashtable();
            PdfArray glyphWidthObjects = (PdfArray)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Widths);
            if (glyphWidthObjects != null) {
                ByteArray charCode = new ByteArray(new byte[]{(byte)((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.FirstChar)).getIntValue()});
                for (PdfDirectObject glyphWidthObject : glyphWidthObjects) {
                    Integer code;
                    int glyphWidth = ((PdfNumber)glyphWidthObject).getIntValue();
                    if (glyphWidth > 0 && (code = (Integer)this.codes.get(charCode)) != null) {
                        this.glyphWidths.put((Integer)this.glyphIndexes.get(code), glyphWidth);
                    }
                    charCode.data[0] = (byte)(charCode.data[0] + 1);
                }
            }
        }
        if ((descriptor = this.getDescriptor()) != null) {
            PdfNumber defaultGlyphWidthObject = (PdfNumber)descriptor.get(PdfName.MissingWidth);
            this.defaultGlyphWidth = defaultGlyphWidthObject != null ? defaultGlyphWidthObject.getIntValue() : 0;
        }
    }
}

