/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.util.parsers.ParseException;

final class OpenFontParser {
    private static final int MicrosoftLanguage_UsEnglish = 1033;
    private static final int NameID_FontPostscriptName = 6;
    private static final int PlatformID_Unicode = 0;
    private static final int PlatformID_Macintosh = 1;
    private static final int PlatformID_Microsoft = 3;
    public FontMetrics metrics;
    public String fontName;
    public OutlineFormatEnum outlineFormat;
    public boolean symbolic;
    public Map<Integer, Integer> glyphIndexes;
    public Map<Integer, Integer> glyphKernings;
    public Map<Integer, Integer> glyphWidths;
    public IInputStream fontData;
    private Map<String, Integer> tableOffsets;

    public static boolean isOpenFont(IInputStream fontData) {
        long position = fontData.getPosition();
        fontData.setPosition(0L);
        try {
            try {
                OpenFontParser.getOutlineFormat(fontData.readInt());
            }
            catch (UnsupportedOperationException e) {
                fontData.setPosition(position);
                return false;
            }
            catch (EOFException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            fontData.setPosition(position);
        }
        return true;
    }

    private static OutlineFormatEnum getOutlineFormat(int versionCode) throws UnsupportedOperationException {
        switch (versionCode) {
            case 65536: 
            case 1953658213: {
                return OutlineFormatEnum.TrueType;
            }
            case 0x4F54544F: {
                return OutlineFormatEnum.CFF;
            }
        }
        throw new UnsupportedOperationException("Unknown OpenFont format version.");
    }

    OpenFontParser(IInputStream fontData) {
        this.fontData = fontData;
        this.load();
    }

    private void load() {
        try {
            this.loadTableInfo();
            this.fontName = this.getName(6);
            this.metrics = new FontMetrics();
            this.loadTables();
            this.loadCMap();
            this.loadGlyphWidths();
            this.loadGlyphKerning();
        }
        catch (EOFException e) {
            throw new ParseException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException(e);
        }
    }

    private void loadCMap() throws EOFException {
        Integer tableOffset = this.tableOffsets.get("cmap");
        if (tableOffset == null) {
            throw new ParseException("'cmap' table does NOT exist.");
        }
        int cmap10Offset = 0;
        int cmap31Offset = 0;
        this.fontData.seek(tableOffset + 2);
        int tableCount = this.fontData.readUnsignedShort();
        int tableIndex = 0;
        while (tableIndex < tableCount) {
            int platformID = this.fontData.readUnsignedShort();
            int encodingID = this.fontData.readUnsignedShort();
            int offset = this.fontData.readInt();
            block0 : switch (platformID) {
                case 1: {
                    switch (encodingID) {
                        case 0: {
                            cmap10Offset = offset;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (encodingID) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            cmap31Offset = offset;
                        }
                    }
                }
            }
            ++tableIndex;
        }
        if (cmap31Offset > 0) {
            this.metrics.isCustomEncoding = false;
            this.fontData.seek(tableOffset + cmap31Offset);
        } else if (cmap10Offset > 0) {
            this.metrics.isCustomEncoding = true;
            this.fontData.seek(tableOffset + cmap10Offset);
        } else {
            throw new ParseException("CMAP table unavailable.");
        }
        int format = this.fontData.readUnsignedShort();
        switch (format) {
            case 0: {
                this.loadCMapFormat0();
                break;
            }
            case 4: {
                this.loadCMapFormat4();
                break;
            }
            case 6: {
                this.loadCMapFormat6();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cmap table format " + format + " NOT supported.");
            }
        }
    }

    private void loadCMapFormat0() throws EOFException {
        this.symbolic = true;
        this.glyphIndexes = new Hashtable<Integer, Integer>(256);
        this.fontData.skip(4L);
        int code = 0;
        while (code < 256) {
            this.glyphIndexes.put(code, this.fontData.readUnsignedByte());
            ++code;
        }
    }

    private void loadCMapFormat4() throws EOFException {
        this.symbolic = false;
        int tableLength = this.fontData.readUnsignedShort();
        this.fontData.skip(2L);
        int segmentCount = this.fontData.readUnsignedShort() / 2;
        this.fontData.skip(6L);
        int[] endCodes = new int[segmentCount];
        int index = 0;
        while (index < segmentCount) {
            endCodes[index] = this.fontData.readUnsignedShort();
            ++index;
        }
        this.fontData.skip(2L);
        int[] startCodes = new int[segmentCount];
        int index2 = 0;
        while (index2 < segmentCount) {
            startCodes[index2] = this.fontData.readUnsignedShort();
            ++index2;
        }
        short[] deltas = new short[segmentCount];
        int index3 = 0;
        while (index3 < segmentCount) {
            deltas[index3] = this.fontData.readShort();
            ++index3;
        }
        int[] rangeOffsets = new int[segmentCount];
        int index4 = 0;
        while (index4 < segmentCount) {
            rangeOffsets[index4] = this.fontData.readUnsignedShort();
            ++index4;
        }
        int glyphIndexCount = tableLength / 2 - 8 - segmentCount * 4;
        int[] glyphIds = new int[glyphIndexCount];
        int index5 = 0;
        while (index5 < glyphIds.length) {
            glyphIds[index5] = this.fontData.readUnsignedShort();
            ++index5;
        }
        this.glyphIndexes = new Hashtable<Integer, Integer>(glyphIndexCount);
        int segmentIndex = 0;
        while (segmentIndex < segmentCount) {
            int endCode = endCodes[segmentIndex];
            if (endCode < 65535) {
                ++endCode;
            }
            int code = startCodes[segmentIndex];
            while (code < endCode) {
                int glyphIndex;
                if (rangeOffsets[segmentIndex] == 0) {
                    glyphIndex = code + deltas[segmentIndex] & 0xFFFF;
                } else {
                    int glyphIdIndex = rangeOffsets[segmentIndex] / 2 + (code - startCodes[segmentIndex]) - (segmentCount - segmentIndex);
                    glyphIndex = glyphIds[glyphIdIndex] + deltas[segmentIndex] & 0xFFFF;
                }
                this.glyphIndexes.put(code, glyphIndex);
                ++code;
            }
            ++segmentIndex;
        }
    }

    private void loadCMapFormat6() throws EOFException {
        this.symbolic = true;
        this.fontData.skip(4L);
        int firstCode = this.fontData.readUnsignedShort();
        int codeCount = this.fontData.readUnsignedShort();
        this.glyphIndexes = new Hashtable<Integer, Integer>(codeCount);
        int code = firstCode;
        int lastCode = firstCode + codeCount;
        while (code < lastCode) {
            this.glyphIndexes.put(code, this.fontData.readUnsignedShort());
            ++code;
        }
    }

    private String getName(int id) throws EOFException, UnsupportedEncodingException {
        Integer tableOffset = this.tableOffsets.get("name");
        if (tableOffset == null) {
            throw new ParseException("'name' table does NOT exist.");
        }
        this.fontData.seek(tableOffset + 2);
        int recordCount = this.fontData.readUnsignedShort();
        int storageOffset = this.fontData.readUnsignedShort();
        int recordIndex = 0;
        while (recordIndex < recordCount) {
            int platformID = this.fontData.readUnsignedShort();
            if (platformID == 3) {
                this.fontData.skip(2L);
                int languageID = this.fontData.readUnsignedShort();
                if (languageID == 1033) {
                    int nameID = this.fontData.readUnsignedShort();
                    if (nameID == id) {
                        int length = this.fontData.readUnsignedShort();
                        int offset = this.fontData.readUnsignedShort();
                        this.fontData.seek(tableOffset + storageOffset + offset);
                        return this.readString(length, platformID);
                    }
                    this.fontData.skip(4L);
                } else {
                    this.fontData.skip(6L);
                }
            } else {
                this.fontData.skip(10L);
            }
            ++recordIndex;
        }
        return null;
    }

    private void loadGlyphKerning() throws EOFException {
        Integer tableOffset = this.tableOffsets.get("kern");
        if (tableOffset == null) {
            return;
        }
        this.fontData.seek(tableOffset + 2);
        int subtableCount = this.fontData.readUnsignedShort();
        this.glyphKernings = new Hashtable<Integer, Integer>();
        int subtableOffset = (int)this.fontData.getPosition();
        int subtableIndex = 0;
        while (subtableIndex < subtableCount) {
            this.fontData.seek(subtableOffset + 2);
            int length = this.fontData.readUnsignedShort();
            int coverage = this.fontData.readUnsignedShort();
            if ((coverage & 0xFF00) == 0) {
                int pairCount = this.fontData.readUnsignedShort();
                this.fontData.skip(6L);
                int pairIndex = 0;
                while (pairIndex < pairCount) {
                    int pair = this.fontData.readInt();
                    int value = (int)((float)this.fontData.readShort() * this.metrics.unitNorm);
                    this.glyphKernings.put(pair, value);
                    ++pairIndex;
                }
            }
            subtableOffset += length;
            ++subtableIndex;
        }
    }

    private void loadGlyphWidths() throws EOFException {
        Integer tableOffset = this.tableOffsets.get("hmtx");
        if (tableOffset == null) {
            throw new ParseException("'hmtx' table does NOT exist.");
        }
        this.fontData.seek(tableOffset.intValue());
        this.glyphWidths = new Hashtable<Integer, Integer>(this.metrics.numberOfHMetrics);
        int index = 0;
        while (index < this.metrics.numberOfHMetrics) {
            this.glyphWidths.put(index, (int)((float)this.fontData.readUnsignedShort() * this.metrics.unitNorm));
            this.fontData.skip(2L);
            ++index;
        }
    }

    private void loadTableInfo() throws EOFException, UnsupportedEncodingException {
        this.fontData.seek(0L);
        this.outlineFormat = OpenFontParser.getOutlineFormat(this.fontData.readInt());
        int tableCount = this.fontData.readUnsignedShort();
        this.fontData.skip(6L);
        this.tableOffsets = new Hashtable<String, Integer>(tableCount);
        int index = 0;
        while (index < tableCount) {
            String tag = this.readAsciiString(4);
            this.fontData.skip(4L);
            int offset = this.fontData.readInt();
            this.tableOffsets.put(tag, offset);
            this.fontData.skip(4L);
            ++index;
        }
    }

    private void loadTables() throws EOFException {
        Integer tableOffset = this.tableOffsets.get("head");
        if (tableOffset == null) {
            throw new ParseException("'head' table does NOT exist.");
        }
        this.fontData.seek(tableOffset + 16);
        this.metrics.flags = this.fontData.readUnsignedShort();
        this.metrics.unitsPerEm = this.fontData.readUnsignedShort();
        this.metrics.unitNorm = 1000.0f / (float)this.metrics.unitsPerEm;
        this.fontData.skip(16L);
        this.metrics.xMin = this.fontData.readShort();
        this.metrics.yMin = this.fontData.readShort();
        this.metrics.xMax = this.fontData.readShort();
        this.metrics.yMax = this.fontData.readShort();
        this.metrics.macStyle = this.fontData.readUnsignedShort();
        tableOffset = this.tableOffsets.get("OS/2");
        if (tableOffset != null) {
            this.fontData.seek(tableOffset.intValue());
            int version = this.fontData.readUnsignedShort();
            this.fontData.skip(66L);
            this.metrics.sTypoAscender = this.fontData.readShort();
            this.metrics.sTypoDescender = this.fontData.readShort();
            this.metrics.sTypoLineGap = this.fontData.readShort();
            if (version >= 2) {
                this.fontData.skip(12L);
                this.metrics.sxHeight = this.fontData.readShort();
                this.metrics.sCapHeight = this.fontData.readShort();
            } else {
                this.metrics.sxHeight = (short)(0.5 * (double)this.metrics.unitsPerEm);
                this.metrics.sCapHeight = (short)(0.7 * (double)this.metrics.unitsPerEm);
            }
        }
        if ((tableOffset = this.tableOffsets.get("hhea")) == null) {
            throw new ParseException("'hhea' table does NOT exist.");
        }
        this.fontData.seek(tableOffset + 4);
        this.metrics.ascender = this.fontData.readShort();
        this.metrics.descender = this.fontData.readShort();
        this.metrics.lineGap = this.fontData.readShort();
        this.metrics.advanceWidthMax = this.fontData.readUnsignedShort();
        this.metrics.minLeftSideBearing = this.fontData.readShort();
        this.metrics.minRightSideBearing = this.fontData.readShort();
        this.metrics.xMaxExtent = this.fontData.readShort();
        this.metrics.caretSlopeRise = this.fontData.readShort();
        this.metrics.caretSlopeRun = this.fontData.readShort();
        this.fontData.skip(12L);
        this.metrics.numberOfHMetrics = this.fontData.readUnsignedShort();
        tableOffset = this.tableOffsets.get("post");
        if (tableOffset == null) {
            throw new ParseException("'post' table does NOT exist.");
        }
        this.fontData.seek(tableOffset + 4);
        this.metrics.italicAngle = (float)this.fontData.readShort() + (float)this.fontData.readUnsignedShort() / 16384.0f;
        this.metrics.underlinePosition = this.fontData.readShort();
        this.metrics.underlineThickness = this.fontData.readShort();
        this.metrics.isFixedPitch = this.fontData.readInt() != 0;
    }

    private String readAsciiString(int length) throws EOFException, UnsupportedEncodingException {
        return this.readString(length, "ISO-8859-1");
    }

    private String readString(int length, int platformID) throws EOFException, UnsupportedEncodingException {
        switch (platformID) {
            case 0: 
            case 3: {
                return this.readUnicodeString(length);
            }
        }
        return this.readAsciiString(length);
    }

    private String readString(int length, String charName) throws EOFException, UnsupportedEncodingException {
        byte[] data = new byte[length];
        this.fontData.read(data);
        return new String(data, charName);
    }

    private String readUnicodeString(int length) throws EOFException, UnsupportedEncodingException {
        return this.readString(length, "UTF-16");
    }

    static final class FontMetrics {
        public boolean isCustomEncoding;
        public float unitNorm;
        public int flags;
        public int unitsPerEm;
        public short xMin;
        public short yMin;
        public short xMax;
        public short yMax;
        public int macStyle;
        public short ascender;
        public short descender;
        public short lineGap;
        public int advanceWidthMax;
        public short minLeftSideBearing;
        public short minRightSideBearing;
        public short xMaxExtent;
        public short caretSlopeRise;
        public short caretSlopeRun;
        public int numberOfHMetrics;
        public short sTypoAscender;
        public short sTypoDescender;
        public short sTypoLineGap;
        public short sxHeight;
        public short sCapHeight;
        public float italicAngle;
        public short underlinePosition;
        public short underlineThickness;
        public boolean isFixedPitch;

        FontMetrics() {
        }
    }

    static enum OutlineFormatEnum {
        TrueType,
        CFF;

    }
}

