/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.FileInputStream;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.fonts.CMapParser;
import org.pdfclown.documents.contents.fonts.CompositeFont;
import org.pdfclown.documents.contents.fonts.MMType1Font;
import org.pdfclown.documents.contents.fonts.OpenFontParser;
import org.pdfclown.documents.contents.fonts.StandardType1Font;
import org.pdfclown.documents.contents.fonts.TrueTypeFont;
import org.pdfclown.documents.contents.fonts.Type0Font;
import org.pdfclown.documents.contents.fonts.Type1Font;
import org.pdfclown.documents.contents.fonts.Type2Font;
import org.pdfclown.documents.contents.fonts.Type3Font;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.BiMap;
import org.pdfclown.util.ByteArray;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF10)
public abstract class Font
extends PdfObjectWrapper<PdfDictionary> {
    protected BiMap<ByteArray, Integer> codes;
    protected int defaultGlyphWidth;
    protected Map<Integer, Integer> glyphIndexes;
    protected Map<Integer, Integer> glyphKernings;
    protected Map<Integer, Integer> glyphWidths;
    protected boolean symbolic = true;
    protected Set<Integer> usedCodes;
    private int charCodeMaxLength = 0;

    public static Font get(Document context, String path) {
        try {
            return Font.get(context, new FileInputStream(new RandomAccessFile(path, "r")));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Font get(Document context, File file) {
        return Font.get(context, file.getPath());
    }

    public static Font get(Document context, IInputStream fontData) {
        if (OpenFontParser.isOpenFont(fontData)) {
            return CompositeFont.get(context, fontData);
        }
        throw new NotImplementedException();
    }

    public static final double getScalingFactor(double size) {
        return 0.001 * size;
    }

    public static final Font wrap(PdfDirectObject baseObject) {
        PdfReference reference;
        if (baseObject == null) {
            return null;
        }
        Hashtable<PdfReference, Object> cache = reference.getIndirectObject().getFile().getDocument().cache;
        reference = (PdfReference)baseObject;
        if (cache.containsKey(reference)) {
            return (Font)cache.get(reference);
        }
        PdfDictionary fontDictionary = (PdfDictionary)reference.getDataObject();
        PdfName fontType = (PdfName)fontDictionary.get(PdfName.Subtype);
        if (fontType == null) {
            throw new RuntimeException("Font type undefined (reference: " + reference + ")");
        }
        if (fontType.equals(PdfName.Type1)) {
            if (!fontDictionary.containsKey(PdfName.FontDescriptor)) {
                return new StandardType1Font(reference);
            }
            PdfDictionary fontDescriptor = (PdfDictionary)fontDictionary.resolve(PdfName.FontDescriptor);
            if (fontDescriptor.containsKey(PdfName.FontFile3) && ((PdfName)((PdfStream)fontDescriptor.resolve(PdfName.FontFile3)).getHeader().resolve(PdfName.Subtype)).equals(PdfName.OpenType)) {
                throw new NotImplementedException();
            }
            return new Type1Font(reference);
        }
        if (fontType.equals(PdfName.TrueType)) {
            return new TrueTypeFont(reference);
        }
        if (fontType.equals(PdfName.Type0)) {
            PdfDictionary cidFontDictionary = (PdfDictionary)((PdfArray)fontDictionary.resolve(PdfName.DescendantFonts)).resolve(0);
            PdfName cidFontType = (PdfName)cidFontDictionary.get(PdfName.Subtype);
            if (cidFontType.equals(PdfName.CIDFontType0)) {
                return new Type0Font(reference);
            }
            if (cidFontType.equals(PdfName.CIDFontType2)) {
                return new Type2Font(reference);
            }
            throw new NotImplementedException("Type 0 subtype " + cidFontType + " not supported yet.");
        }
        if (fontType.equals(PdfName.Type3)) {
            return new Type3Font(reference);
        }
        if (fontType.equals(PdfName.MMType1)) {
            return new MMType1Font(reference);
        }
        throw new UnsupportedOperationException("Unknown font type: " + fontType + " (reference: " + reference + ")");
    }

    protected Font(Document context) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Font}));
        this.initialize();
    }

    protected Font(PdfDirectObject baseObject) {
        super(baseObject);
        this.initialize();
        this.load();
    }

    public final String decode(byte[] code) {
        StringBuilder textBuilder = new StringBuilder();
        byte[][] codeBuffers = new byte[this.charCodeMaxLength + 1][];
        int codeBufferIndex = 0;
        while (codeBufferIndex <= this.charCodeMaxLength) {
            codeBuffers[codeBufferIndex] = new byte[codeBufferIndex];
            ++codeBufferIndex;
        }
        int position = 0;
        int codeLength = code.length;
        int codeBufferSize = 1;
        while (position < codeLength) {
            byte[] codeBuffer = codeBuffers[codeBufferSize];
            System.arraycopy(code, position, codeBuffer, 0, codeBufferSize);
            Integer textChar = (Integer)this.codes.get(new ByteArray(codeBuffer));
            if (textChar == null) {
                if (codeBufferSize < this.charCodeMaxLength) {
                    ++codeBufferSize;
                    continue;
                }
                textChar = 32;
            }
            textBuilder.append((char)textChar.intValue());
            position += codeBufferSize;
            codeBufferSize = 1;
        }
        return textBuilder.toString();
    }

    public final byte[] encode(String text) {
        ByteArrayOutputStream encodedStream = new ByteArrayOutputStream();
        try {
            int index = 0;
            int length = text.length();
            while (index < length) {
                char textCode = text.charAt(index);
                byte[] charCode = this.codes.getKey((Integer)Integer.valueOf((int)textCode)).data;
                encodedStream.write(charCode);
                this.usedCodes.add(Integer.valueOf(textCode));
                ++index;
            }
            encodedStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return encodedStream.toByteArray();
    }

    @Override
    public final boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && ((Font)object).getName().equals(this.getName());
    }

    public double getAscent() {
        return ((PdfNumber)this.getDescriptor().get(PdfName.Ascent)).getDoubleValue();
    }

    public final double getAscent(double size) {
        return this.getAscent() * Font.getScalingFactor(size);
    }

    public double getDescent() {
        return ((PdfNumber)this.getDescriptor().get(PdfName.Descent)).getDoubleValue();
    }

    public final double getDescent(double size) {
        return this.getDescent() * Font.getScalingFactor(size);
    }

    public EnumSet<FlagsEnum> getFlags() {
        PdfInteger flagsObject = (PdfInteger)this.getDescriptor().resolve(PdfName.Flags);
        if (flagsObject == null) {
            return EnumSet.noneOf(FlagsEnum.class);
        }
        return FlagsEnum.toEnumSet((Integer)flagsObject.getRawValue());
    }

    public final double getHeight(char textChar) {
        return this.getLineHeight();
    }

    public final double getHeight(char textChar, double size) {
        return this.getHeight(textChar) * Font.getScalingFactor(size);
    }

    public final double getHeight(String text) {
        return this.getLineHeight();
    }

    public final double getHeight(String text, double size) {
        return this.getHeight(text) * Font.getScalingFactor(size);
    }

    public final double getKernedWidth(String text, double size) {
        return (double)(this.getWidth(text) + this.getKerning(text)) * Font.getScalingFactor(size);
    }

    public final int getKerning(char textChar1, char textChar2) {
        if (this.glyphKernings == null) {
            return 0;
        }
        Integer textChar1Index = this.glyphIndexes.get(textChar1);
        if (textChar1Index == null) {
            return 0;
        }
        Integer textChar2Index = this.glyphIndexes.get(textChar2);
        if (textChar2Index == null) {
            return 0;
        }
        Integer kerning = this.glyphKernings.get(textChar1Index << 16 + textChar2Index);
        if (kerning == null) {
            return 0;
        }
        return kerning;
    }

    public final int getKerning(String text) {
        int kerning = 0;
        char[] textChars = text.toCharArray();
        int index = 0;
        int length = text.length() - 1;
        while (index < length) {
            kerning += this.getKerning(textChars[index], textChars[index + 1]);
            ++index;
        }
        return kerning;
    }

    public final double getKerning(String text, double size) {
        return (double)this.getKerning(text) * Font.getScalingFactor(size);
    }

    public double getLineHeight() {
        return this.getAscent() - this.getDescent();
    }

    public final double getLineHeight(double size) {
        return this.getLineHeight() * Font.getScalingFactor(size);
    }

    public final String getName() {
        return ((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.BaseFont)).toString();
    }

    public int getWidth(char textChar) {
        Integer glyphIndex = this.glyphIndexes.get(textChar);
        if (glyphIndex == null) {
            return 0;
        }
        Integer glyphWidth = this.glyphWidths.get(glyphIndex);
        return glyphWidth != null ? glyphWidth : this.defaultGlyphWidth;
    }

    public final double getWidth(char textChar, double size) {
        return (double)this.getWidth(textChar) * Font.getScalingFactor(size);
    }

    public int getWidth(String text) {
        int width = 0;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char textChar = cArray[n2];
            width += this.getWidth(textChar);
            ++n2;
        }
        return width;
    }

    public final double getWidth(String text, double size) {
        return (double)this.getWidth(text) * Font.getScalingFactor(size);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isSymbolic() {
        return this.symbolic;
    }

    protected abstract PdfDictionary getDescriptor();

    protected void load() {
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.ToUnicode)) {
            PdfStream toUnicodeStream = (PdfStream)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.ToUnicode);
            CMapParser parser = new CMapParser(toUnicodeStream.getBody());
            this.codes = new BiMap<ByteArray, Integer>(parser.parse());
            this.symbolic = false;
        }
        this.onLoad();
        for (ByteArray charCode : this.codes.keySet()) {
            if (charCode.data.length <= this.charCodeMaxLength) continue;
            this.charCodeMaxLength = charCode.data.length;
        }
    }

    protected abstract void onLoad();

    private void initialize() {
        this.usedCodes = new HashSet<Integer>();
        this.getDocument().cache.put((PdfReference)this.getBaseObject(), this);
    }

    public static enum FlagsEnum {
        FixedPitch(1),
        Serif(2),
        Symbolic(4),
        Script(8),
        Nonsymbolic(32),
        Italic(64),
        AllCap(65536),
        SmallCap(131072),
        ForceBold(262144);

        private final int code;

        public static int toInt(EnumSet<FlagsEnum> flags) {
            int flagsMask = 0;
            for (FlagsEnum flag : flags) {
                flagsMask |= flag.getCode();
            }
            return flagsMask;
        }

        public static EnumSet<FlagsEnum> toEnumSet(int flagsMask) {
            EnumSet<FlagsEnum> flags = EnumSet.noneOf(FlagsEnum.class);
            FlagsEnum[] flagsEnumArray = FlagsEnum.values();
            int n = flagsEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagsEnum flag = flagsEnumArray[n2];
                if ((flagsMask & flag.getCode()) > 0) {
                    flags.add(flag);
                }
                ++n2;
            }
            return flags;
        }

        private FlagsEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

