/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.pdfclown.documents.contents.fonts.GlyphMapping;
import org.pdfclown.documents.contents.fonts.MacRomanEncoding;
import org.pdfclown.documents.contents.fonts.StandardEncoding;
import org.pdfclown.documents.contents.fonts.WinAnsiEncoding;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.ByteArray;

class Encoding {
    private static final Map<PdfName, Encoding> Encodings = new HashMap<PdfName, Encoding>();
    private final Hashtable<ByteArray, Integer> codes = new Hashtable();

    static {
        Encodings.put(PdfName.StandardEncoding, new StandardEncoding());
        Encodings.put(PdfName.MacRomanEncoding, new MacRomanEncoding());
        Encodings.put(PdfName.WinAnsiEncoding, new WinAnsiEncoding());
    }

    Encoding() {
    }

    public static Encoding get(PdfName name) {
        return Encodings.get(name);
    }

    public Map<ByteArray, Integer> getCodes() {
        return new Hashtable<ByteArray, Integer>(this.codes);
    }

    protected void put(int charCode, String charName) {
        this.codes.put(new ByteArray(new byte[]{(byte)charCode}), GlyphMapping.nameToCode(charName));
    }
}

