/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdfclown.documents.contents.fonts.GlyphMapping;

final class AfmParser {
    public FontMetrics metrics;
    public Map<Integer, Integer> glyphIndexes;
    public Map<Integer, Integer> glyphKernings;
    public Map<Integer, Integer> glyphWidths;
    public BufferedReader fontData;

    AfmParser(BufferedReader fontData) {
        this.fontData = fontData;
        this.load();
    }

    private void load() {
        try {
            this.metrics = new FontMetrics();
            this.loadFontHeader();
            this.loadCharMetrics();
            this.loadKerningData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadFontHeader() throws IOException {
        String line;
        Pattern linePattern = Pattern.compile("(\\S+)\\s+(.+)");
        while ((line = this.fontData.readLine()) != null) {
            Matcher lineMatcher = linePattern.matcher(line);
            if (!lineMatcher.find()) continue;
            String key = lineMatcher.group(1);
            if (key.equals("FontName")) {
                this.metrics.fontName = lineMatcher.group(2);
                continue;
            }
            if (key.equals("Weight")) {
                this.metrics.weight = lineMatcher.group(2);
                continue;
            }
            if (key.equals("ItalicAngle")) {
                this.metrics.italicAngle = Float.valueOf(lineMatcher.group(2)).floatValue();
                continue;
            }
            if (key.equals("IsFixedPitch")) {
                this.metrics.isFixedPitch = lineMatcher.group(2).equals("true");
                continue;
            }
            if (key.equals("FontBBox")) {
                String[] coordinates = lineMatcher.group(2).split("\\s+");
                this.metrics.xMin = Short.valueOf(coordinates[0]);
                this.metrics.yMin = Short.valueOf(coordinates[1]);
                this.metrics.xMax = Short.valueOf(coordinates[2]);
                this.metrics.yMax = Short.valueOf(coordinates[3]);
                continue;
            }
            if (key.equals("UnderlinePosition")) {
                this.metrics.underlinePosition = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("UnderlineThickness")) {
                this.metrics.underlineThickness = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("EncodingScheme")) {
                this.metrics.isCustomEncoding = lineMatcher.group(2).equals("FontSpecific");
                continue;
            }
            if (key.equals("CapHeight")) {
                this.metrics.capHeight = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("XHeight")) {
                this.metrics.xHeight = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("Ascender")) {
                this.metrics.ascender = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("Descender")) {
                this.metrics.descender = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("StdHW")) {
                this.metrics.stemH = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("StdVW")) {
                this.metrics.stemV = Short.valueOf(lineMatcher.group(2));
                continue;
            }
            if (key.equals("StartCharMetrics")) break;
        }
        if (this.metrics.ascender == 0) {
            this.metrics.ascender = this.metrics.yMax;
        }
        if (this.metrics.descender == 0) {
            this.metrics.descender = this.metrics.yMin;
        }
    }

    private void loadCharMetrics() throws IOException {
        String line;
        this.glyphIndexes = new Hashtable<Integer, Integer>();
        this.glyphWidths = new Hashtable<Integer, Integer>();
        Pattern linePattern = Pattern.compile("C (\\S+) ; WX (\\S+) ; N (\\S+)");
        int implicitCharCode = Short.MAX_VALUE;
        while ((line = this.fontData.readLine()) != null) {
            Matcher lineMatcher = linePattern.matcher(line);
            if (!lineMatcher.find()) {
                if (!line.equals("EndCharMetrics")) continue;
                break;
            }
            int charCode = Integer.valueOf(lineMatcher.group(1));
            int width = Integer.valueOf(lineMatcher.group(2));
            String charName = lineMatcher.group(3);
            if (charCode < 0) {
                if (charName == null) continue;
                charCode = ++implicitCharCode;
            }
            int code = charName == null || this.metrics.isCustomEncoding ? charCode : GlyphMapping.nameToCode(charName);
            this.glyphIndexes.put(code, charCode);
            this.glyphWidths.put(charCode, width);
        }
    }

    private void loadKerningData() throws IOException {
        String line;
        this.glyphKernings = new Hashtable<Integer, Integer>();
        while ((line = this.fontData.readLine()) != null) {
            if (line.startsWith("StartKernPairs")) break;
        }
        Pattern linePattern = Pattern.compile("KPX (\\S+) (\\S+) (\\S+)");
        while ((line = this.fontData.readLine()) != null) {
            Matcher lineMatcher = linePattern.matcher(line);
            if (!lineMatcher.find()) {
                if (!line.equals("EndKernPairs")) continue;
                break;
            }
            int code1 = GlyphMapping.nameToCode(lineMatcher.group(1));
            int code2 = GlyphMapping.nameToCode(lineMatcher.group(2));
            int pair = code1 << 16 + code2;
            int value = Integer.valueOf(lineMatcher.group(3));
            this.glyphKernings.put(pair, value);
        }
    }

    static final class FontMetrics {
        public boolean isCustomEncoding;
        public String fontName;
        public String weight;
        public float italicAngle;
        public boolean isFixedPitch;
        public short xMin;
        public short yMin;
        public short xMax;
        public short yMax;
        public short underlinePosition;
        public short underlineThickness;
        public short capHeight;
        public short xHeight;
        public short ascender;
        public short descender;
        public short stemH;
        public short stemV;

        FontMetrics() {
        }
    }
}

