/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.entities;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import org.pdfclown.bytes.FileInputStream;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.contents.entities.Entity;
import org.pdfclown.documents.contents.entities.JpegImage;

public abstract class Image
extends Entity {
    private int bitsPerComponent;
    private int height;
    private int width;
    private final IInputStream stream;

    public static Image get(String path) {
        try {
            return Image.get(new FileInputStream(new RandomAccessFile(path, "r")));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Image get(File file) {
        return Image.get(file.getPath());
    }

    public static Image get(IInputStream stream) {
        try {
            byte[] formatMarkerBytes = new byte[2];
            stream.read(formatMarkerBytes);
            if (formatMarkerBytes[0] == -1 && formatMarkerBytes[1] == -40) {
                return new JpegImage(stream);
            }
            return null;
        }
        catch (EOFException e) {
            throw new RuntimeException(e);
        }
    }

    protected Image(IInputStream stream) {
        this.stream = stream;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected IInputStream getStream() {
        return this.stream;
    }

    protected void setBitsPerComponent(int value) {
        this.bitsPerComponent = value;
    }

    protected void setHeight(int value) {
        this.height = value;
    }

    protected void setWidth(int value) {
        this.width = value;
    }
}

