/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.composition;

import java.util.regex.Pattern;
import org.pdfclown.documents.contents.fonts.Font;

final class TextFitter {
    private final Font font;
    private final double fontSize;
    private final boolean hyphenation;
    private final char hyphenationCharacter;
    private final String text;
    private double width;
    private int beginIndex = 0;
    private int endIndex = -1;
    private String fittedText;
    private double fittedWidth;

    TextFitter(String text, double width, Font font, double fontSize, boolean hyphenation, char hyphenationCharacter) {
        this.text = text;
        this.width = width;
        this.font = font;
        this.fontSize = fontSize;
        this.hyphenation = hyphenation;
        this.hyphenationCharacter = hyphenationCharacter;
    }

    public boolean fit(boolean unspacedFitting) {
        return this.fit(this.endIndex + 1, this.width, unspacedFitting);
    }

    /*
     * Unable to fully structure code
     */
    public boolean fit(int index, double width, boolean unspacedFitting) {
        this.beginIndex = index;
        this.width = width;
        this.fittedText = null;
        this.fittedWidth = 0.0;
        hyphen = "";
        pattern = Pattern.compile("(\\s*)(\\S*)");
        matcher = pattern.matcher(this.text);
        matcher.region(this.beginIndex, this.text.length());
        block3: while (matcher.find()) {
            block7: {
                block8: {
                    spaceIndex = matcher.start(1);
                    spaceEnd = matcher.end(1);
                    while (spaceIndex < spaceEnd) {
                        switch (this.text.charAt(spaceIndex)) {
                            case '\n': 
                            case '\r': {
                                index = spaceIndex;
                                break block3;
                            }
                            default: {
                                ++spaceIndex;
                            }
                        }
                    }
                    wordEndIndex = matcher.end(0);
                    wordWidth = this.font.getWidth(matcher.group(0), this.fontSize);
                    this.fittedWidth += wordWidth;
                    if (!(this.fittedWidth > width)) break block7;
                    this.fittedWidth -= wordWidth;
                    wordEndIndex = index;
                    if (!this.hyphenation && (wordEndIndex > this.beginIndex || !unspacedFitting || this.text.charAt(this.beginIndex) == ' ')) break;
                    do {
                        textChar = this.text.charAt(wordEndIndex);
                        wordWidth = this.font.getWidth(textChar, this.fontSize);
                        ++wordEndIndex;
                        this.fittedWidth += wordWidth;
                    } while (!(this.fittedWidth > width));
                    this.fittedWidth -= wordWidth;
                    --wordEndIndex;
                    if (!this.hyphenation) break block8;
                    if (wordEndIndex <= index + 4) ** GOTO lbl47
                    index = --wordEndIndex;
                    textChar = this.text.charAt(wordEndIndex);
                    this.fittedWidth -= this.font.getWidth(textChar, this.fontSize);
                    textChar = this.hyphenationCharacter;
                    this.fittedWidth += this.font.getWidth(textChar, this.fontSize);
                    hyphen = String.valueOf(textChar);
                    break;
lbl-1000:
                    // 1 sources

                    {
                        textChar = this.text.charAt(--wordEndIndex);
                        this.fittedWidth -= this.font.getWidth(textChar, this.fontSize);
lbl47:
                        // 2 sources

                        ** while (wordEndIndex > index)
                    }
lbl48:
                    // 1 sources

                    break;
                }
                index = wordEndIndex;
                break;
            }
            index = wordEndIndex;
        }
        this.fittedText = String.valueOf(this.text.substring(this.beginIndex, index)) + hyphen;
        this.endIndex = index;
        return this.fittedWidth > 0.0;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getFittedText() {
        return this.fittedText;
    }

    public double getFittedWidth() {
        return this.fittedWidth;
    }

    public Font getFont() {
        return this.font;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public char getHyphenationCharacter() {
        return this.hyphenationCharacter;
    }

    public String getText() {
        return this.text;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isHyphenation() {
        return this.hyphenation;
    }
}

