/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.composition;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.composition.Length;
import org.pdfclown.documents.contents.composition.LineAlignmentEnum;
import org.pdfclown.documents.contents.composition.PrimitiveComposer;
import org.pdfclown.documents.contents.composition.TextFitter;
import org.pdfclown.documents.contents.composition.XAlignmentEnum;
import org.pdfclown.documents.contents.composition.YAlignmentEnum;
import org.pdfclown.documents.contents.objects.ContainerObject;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.LocalGraphicsState;
import org.pdfclown.documents.contents.objects.ModifyCTM;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.documents.contents.objects.SetWordSpace;
import org.pdfclown.documents.contents.xObjects.XObject;
import org.pdfclown.util.NotImplementedException;
import org.pdfclown.util.math.OperationUtils;

public final class BlockComposer {
    private final PrimitiveComposer baseComposer;
    private final ContentScanner scanner;
    private boolean hyphenation;
    private char hyphenationCharacter = (char)45;
    private LineAlignmentEnum lineAlignment = LineAlignmentEnum.BaseLine;
    private Length lineSpace = new Length(0.0, Length.UnitModeEnum.Relative);
    private XAlignmentEnum xAlignment;
    private YAlignmentEnum yAlignment;
    private Rectangle2D frame;
    private Rectangle2D.Double boundBox;
    private Row currentRow;
    private boolean rowEnded;
    private LocalGraphicsState container;
    private double lastFontSize;

    public BlockComposer(PrimitiveComposer baseComposer) {
        this.baseComposer = baseComposer;
        this.scanner = baseComposer.getScanner();
    }

    public void begin(Rectangle2D frame, XAlignmentEnum xAlignment, YAlignmentEnum yAlignment) {
        this.frame = frame;
        this.xAlignment = xAlignment;
        this.yAlignment = yAlignment;
        this.lastFontSize = 0.0;
        this.container = this.baseComposer.beginLocalState();
        this.boundBox = new Rectangle2D.Double(frame.getX(), frame.getY(), frame.getWidth(), 0.0);
        this.beginRow();
    }

    public void end() {
        this.endRow(true);
        this.container.getObjects().add(0, new ModifyCTM(1.0, 0.0, 0.0, 1.0, this.boundBox.x, -this.boundBox.y));
        this.baseComposer.end();
    }

    public PrimitiveComposer getBaseComposer() {
        return this.baseComposer;
    }

    public Rectangle2D getBoundBox() {
        return this.boundBox;
    }

    public Rectangle2D getFrame() {
        return this.frame;
    }

    public char getHyphenationCharacter() {
        return this.hyphenationCharacter;
    }

    public LineAlignmentEnum getLineAlignment() {
        return this.lineAlignment;
    }

    public Length getLineSpace() {
        return this.lineSpace;
    }

    public ContentScanner getScanner() {
        return this.scanner;
    }

    public XAlignmentEnum getXAlignment() {
        return this.xAlignment;
    }

    public YAlignmentEnum getYAlignment() {
        return this.yAlignment;
    }

    public boolean isHyphenation() {
        return this.hyphenation;
    }

    public void setHyphenation(boolean value) {
        this.hyphenation = value;
    }

    public void setHyphenationCharacter(char value) {
        this.hyphenationCharacter = value;
    }

    public void setLineAlignment(LineAlignmentEnum value) {
        this.lineAlignment = value;
    }

    public void setLineSpace(Length value) {
        this.lineSpace = value;
    }

    public void showBreak() {
        this.endRow(true);
        this.beginRow();
    }

    public void showBreak(Dimension2D offset) {
        this.showBreak();
        this.currentRow.y += offset.getHeight();
        this.currentRow.width = offset.getWidth();
    }

    public void showBreak(XAlignmentEnum xAlignment) {
        this.showBreak();
        this.xAlignment = xAlignment;
    }

    public void showBreak(Dimension2D offset, XAlignmentEnum xAlignment) {
        this.showBreak(offset);
        this.xAlignment = xAlignment;
    }

    public int showText(String text) {
        return this.showText(text, (Object)this.lineAlignment);
    }

    /*
     * Unable to fully structure code
     */
    public int showText(String text, Object lineAlignment) {
        if (this.currentRow == null || text == null) {
            return 0;
        }
        state = this.baseComposer.getState();
        font = state.getFont();
        fontSize = state.getFontSize();
        lineHeight = font.getLineHeight(fontSize);
        baseLine = font.getAscent(fontSize);
        lineAlignment = this.resolveLineAlignment(lineAlignment);
        textFitter = new TextFitter(text, 0.0, font, fontSize, this.hyphenation, this.hyphenationCharacter);
        textLength = text.length();
        index = 0;
        block4: while (true) {
            if (this.currentRow.width != 0.0) ** GOTO lbl18
            while (index != textLength) {
                if (text.charAt(index) == ' ') {
                    ++index;
                    continue;
                }
lbl18:
                // 3 sources

                if (OperationUtils.compare(this.currentRow.y + lineHeight, this.frame.getHeight()) == 1) {
                    this.endRow(false);
                    break block4;
                }
                if (textFitter.fit(index, this.frame.getWidth() - this.currentRow.width, this.currentRow.spaceCount == 0)) {
                    textChunk = textFitter.getFittedText();
                    textChunkWidth = textFitter.getFittedWidth();
                    textChunkLocation = new Point2D.Double(this.currentRow.width, this.currentRow.y);
                    object = new RowObject(RowObject.TypeEnum.Text, this.baseComposer.beginLocalState(), lineHeight, textChunkWidth, this.countOccurrence(' ', textChunk), lineAlignment, baseLine);
                    this.baseComposer.showText(textChunk, textChunkLocation);
                    this.baseComposer.end();
                    this.addRowObject(object, lineAlignment);
                    index = textFitter.getEndIndex();
                }
                while (index != textLength) {
                    switch (text.charAt(index)) {
                        case '\r': {
                            break;
                        }
                        case '\n': {
                            ++index;
                            this.showBreak();
                            continue block4;
                        }
                        default: {
                            this.endRow(false);
                            this.beginRow();
                            continue block4;
                        }
                    }
                    ++index;
                }
                break block4;
            }
            break;
        }
        if (index >= 0 && lineAlignment == LineAlignmentEnum.BaseLine) {
            this.lastFontSize = fontSize;
        }
        return index;
    }

    public boolean showXObject(XObject xObject, Dimension2D size) {
        return this.showXObject(xObject, size, (Object)this.lineAlignment);
    }

    public boolean showXObject(XObject xObject, Dimension2D size, Object lineAlignment) {
        if (this.currentRow == null || xObject == null) {
            return false;
        }
        if (size == null) {
            size = xObject.getSize();
        }
        lineAlignment = this.resolveLineAlignment(lineAlignment);
        while (true) {
            if (OperationUtils.compare(this.currentRow.y + size.getHeight(), this.frame.getHeight()) == 1) {
                this.endRow(false);
                return false;
            }
            if (OperationUtils.compare(this.currentRow.width + size.getWidth(), this.frame.getWidth()) < 1) {
                Point2D.Double location = new Point2D.Double(this.currentRow.width, this.currentRow.y);
                RowObject object = new RowObject(RowObject.TypeEnum.XObject, this.baseComposer.beginLocalState(), size.getHeight(), size.getWidth(), 0, lineAlignment, size.getHeight());
                this.baseComposer.showXObject(xObject, (Point2D)location, size);
                this.baseComposer.end();
                this.addRowObject(object, lineAlignment);
                return true;
            }
            this.endRow(false);
            this.beginRow();
        }
    }

    private void addRowObject(RowObject object, Object lineAlignment) {
        this.currentRow.objects.add(object);
        this.currentRow.spaceCount += object.spaceCount;
        this.currentRow.width += object.width;
        if (lineAlignment instanceof Double || lineAlignment == LineAlignmentEnum.BaseLine) {
            double subGap;
            double gap = lineAlignment instanceof Double ? (Double)lineAlignment : 0.0;
            double superGap = object.baseLine + gap - this.currentRow.baseLine;
            if (superGap > 0.0) {
                this.currentRow.height += superGap;
                this.currentRow.baseLine += superGap;
            }
            if ((subGap = this.currentRow.baseLine + (object.height - object.baseLine) - gap - this.currentRow.height) > 0.0) {
                this.currentRow.height += subGap;
            }
        } else if (object.height > this.currentRow.height) {
            this.currentRow.height = object.height;
        }
    }

    private void beginRow() {
        this.rowEnded = false;
        double rowY = this.boundBox.height;
        if (rowY > 0.0) {
            ContentScanner.GraphicsState state = this.baseComposer.getState();
            rowY += this.lineSpace.getValue(state.getFont().getLineHeight(state.getFontSize()));
        }
        this.currentRow = new Row((ContentPlaceholder)this.baseComposer.add(new ContentPlaceholder()), rowY);
    }

    private int countOccurrence(char value, String text) {
        int count = 0;
        int fromIndex = 0;
        int foundIndex;
        while ((foundIndex = text.indexOf(value, fromIndex)) != -1) {
            ++count;
            fromIndex = foundIndex + 1;
        }
        return count;
    }

    private void endRow(boolean broken) {
        double yOffset;
        if (this.rowEnded) {
            return;
        }
        this.rowEnded = true;
        double[] objectXOffsets = new double[this.currentRow.objects.size()];
        double wordSpace = 0.0;
        double rowXOffset = 0.0;
        ArrayList<RowObject> objects = this.currentRow.objects;
        XAlignmentEnum xAlignment = this.xAlignment;
        switch (xAlignment) {
            case Left: {
                break;
            }
            case Right: {
                rowXOffset = this.frame.getWidth() - this.currentRow.width;
                break;
            }
            case Center: {
                rowXOffset = (this.frame.getWidth() - this.currentRow.width) / 2.0;
                break;
            }
            case Justify: {
                if (this.currentRow.spaceCount == 0 || broken) {
                    xAlignment = XAlignmentEnum.Left;
                    break;
                }
                wordSpace = (this.frame.getWidth() - this.currentRow.width) / (double)this.currentRow.spaceCount;
                int index = 1;
                int count = objects.size();
                while (index < count) {
                    objectXOffsets[index] = objectXOffsets[index - 1] + (double)((RowObject)objects.get((int)(index - 1))).spaceCount * wordSpace;
                    ++index;
                }
                break;
            }
        }
        SetWordSpace wordSpaceOperation = new SetWordSpace(wordSpace);
        int index = objects.size() - 1;
        while (index >= 0) {
            double lineRise;
            LineAlignmentEnum lineAlignment;
            RowObject object = (RowObject)objects.get(index);
            double objectYOffset = 0.0;
            Object objectLineAlignment = object.lineAlignment;
            if (objectLineAlignment instanceof Double) {
                lineAlignment = LineAlignmentEnum.BaseLine;
                lineRise = (Double)objectLineAlignment;
            } else {
                lineAlignment = (LineAlignmentEnum)((Object)objectLineAlignment);
                lineRise = 0.0;
            }
            switch (lineAlignment) {
                case Top: {
                    break;
                }
                case Middle: {
                    objectYOffset = -(this.currentRow.height - object.height) / 2.0;
                    break;
                }
                case BaseLine: {
                    objectYOffset = -(this.currentRow.baseLine - object.baseLine - lineRise);
                    break;
                }
                case Bottom: {
                    objectYOffset = -(this.currentRow.height - object.height);
                    break;
                }
                default: {
                    throw new NotImplementedException("Line alignment " + (Object)((Object)lineAlignment) + " unknown.");
                }
            }
            List<ContentObject> containedGraphics = object.container.getObjects();
            containedGraphics.add(0, wordSpaceOperation);
            containedGraphics.add(0, new ModifyCTM(1.0, 0.0, 0.0, 1.0, objectXOffsets[index] + rowXOffset, objectYOffset));
            --index;
        }
        this.boundBox.height = this.currentRow.y + this.currentRow.height;
        switch (this.yAlignment) {
            case Bottom: {
                yOffset = this.frame.getHeight() - this.boundBox.height;
                break;
            }
            case Middle: {
                yOffset = (this.frame.getHeight() - this.boundBox.height) / 2.0;
                break;
            }
            default: {
                yOffset = 0.0;
            }
        }
        this.boundBox.y = this.frame.getY() + yOffset;
        this.currentRow = null;
    }

    private Object resolveLineAlignment(Object lineAlignment) {
        if (!(lineAlignment instanceof LineAlignmentEnum) && !(lineAlignment instanceof Length)) {
            throw new IllegalArgumentException("'lineAlignment' param MUST be either LineAlignmentEnum or Length.");
        }
        if (lineAlignment == LineAlignmentEnum.Super) {
            lineAlignment = new Length(0.33, Length.UnitModeEnum.Relative);
        } else if (lineAlignment == LineAlignmentEnum.Sub) {
            lineAlignment = new Length(-0.33, Length.UnitModeEnum.Relative);
        }
        if (lineAlignment instanceof Length) {
            if (this.lastFontSize == 0.0) {
                this.lastFontSize = this.baseComposer.getState().getFontSize();
            }
            lineAlignment = ((Length)lineAlignment).getValue(this.lastFontSize);
        }
        return lineAlignment;
    }

    private static final class ContentPlaceholder
    extends Operation {
        public List<ContentObject> objects = new ArrayList<ContentObject>();

        public ContentPlaceholder() {
            super(null);
        }

        public List<ContentObject> getObjects() {
            return this.objects;
        }

        @Override
        public void writeTo(IOutputStream stream, Document context) {
            for (ContentObject object : this.objects) {
                object.writeTo(stream, context);
            }
        }
    }

    private static final class Row {
        public double baseLine;
        public ContentPlaceholder container;
        public double height;
        public ArrayList<RowObject> objects = new ArrayList();
        public int spaceCount = 0;
        public double width;
        public double y;

        Row(ContentPlaceholder container, double y) {
            this.container = container;
            this.y = y;
        }
    }

    private static final class RowObject {
        public double baseLine;
        public ContainerObject container;
        public double height;
        public Object lineAlignment;
        public int spaceCount;
        public TypeEnum type;
        public double width;

        RowObject(TypeEnum type, ContainerObject container, double height, double width, int spaceCount, Object lineAlignment, double baseLine) {
            this.type = type;
            this.container = container;
            this.height = height;
            this.width = width;
            this.spaceCount = spaceCount;
            this.lineAlignment = lineAlignment;
            this.baseLine = baseLine;
        }

        public static enum TypeEnum {
            Text,
            XObject;

        }
    }
}

