/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.Resources;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.Pattern;
import org.pdfclown.documents.contents.colorSpaces.PatternColorSpace;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.Rectangle;

@PDF(value=VersionEnum.PDF12)
public class TilingPattern
extends Pattern<PdfStream> {
    TilingPattern(PatternColorSpace colorSpace, PdfDirectObject baseObject) {
        super(colorSpace, baseObject);
    }

    TilingPattern(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public Colorized colorize(Color<?> color) {
        if (this.getPaintType() != PaintTypeEnum.Uncolored) {
            throw new UnsupportedOperationException("Only uncolored tiling patterns can be colorized.");
        }
        return new Colorized(this, color);
    }

    public Rectangle2D getBox() {
        Rectangle box = Rectangle.wrap(((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.BBox));
        return new Rectangle2D.Double(box.getX(), box.getY(), box.getWidth(), box.getHeight());
    }

    public PaintTypeEnum getPaintType() {
        return PaintTypeEnum.get((Integer)((PdfInteger)((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.PaintType)).getRawValue());
    }

    public Resources getResources() {
        return Resources.wrap(((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.Resources));
    }

    public TilingTypeEnum getTilingType() {
        return TilingTypeEnum.get((Integer)((PdfInteger)((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.TilingType)).getRawValue());
    }

    public double getXStep() {
        return ((PdfNumber)((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.XStep)).getDoubleValue();
    }

    public double getYStep() {
        return ((PdfNumber)((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.YStep)).getDoubleValue();
    }

    public static final class Colorized
    extends TilingPattern {
        private final Color<?> color;

        private Colorized(TilingPattern uncoloredPattern, Color<?> color) {
            super((PatternColorSpace)uncoloredPattern.getColorSpace(), uncoloredPattern.getBaseObject());
            this.color = color;
        }

        public Color<?> getColor() {
            return this.color;
        }
    }

    public static enum PaintTypeEnum {
        Colored(1),
        Uncolored(2);

        private int code;

        public static PaintTypeEnum get(int code) {
            PaintTypeEnum[] paintTypeEnumArray = PaintTypeEnum.values();
            int n = paintTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                PaintTypeEnum paintType = paintTypeEnumArray[n2];
                if (paintType.getCode() == code) {
                    return paintType;
                }
                ++n2;
            }
            return null;
        }

        private PaintTypeEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum TilingTypeEnum {
        ConstantSpacing(1),
        VariableSpacing(2),
        FasterConstantSpacing(3);

        private int code;

        public static TilingTypeEnum get(int code) {
            TilingTypeEnum[] tilingTypeEnumArray = TilingTypeEnum.values();
            int n = tilingTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TilingTypeEnum tilingType = tilingTypeEnumArray[n2];
                if (tilingType.getCode() == code) {
                    return tilingType;
                }
                ++n2;
            }
            return null;
        }

        private TilingTypeEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

