/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.colorSpaces.ColorSpace;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;

@PDF(value=VersionEnum.PDF11)
public abstract class CIEBasedColorSpace
extends ColorSpace<PdfArray> {
    protected CIEBasedColorSpace(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public double[] getBlackPoint() {
        double[] dArray;
        PdfArray blackPointObject = (PdfArray)this.getDictionary().get(PdfName.BlackPoint);
        if (blackPointObject == null) {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.0;
            dArray2[1] = 0.0;
            dArray = dArray2;
            dArray2[2] = 0.0;
        } else {
            double[] dArray3 = new double[3];
            dArray3[0] = ((PdfNumber)blackPointObject.get(0)).getDoubleValue();
            dArray3[1] = ((PdfNumber)blackPointObject.get(1)).getDoubleValue();
            dArray = dArray3;
            dArray3[2] = ((PdfNumber)blackPointObject.get(2)).getDoubleValue();
        }
        return dArray;
    }

    public double[] getWhitePoint() {
        PdfArray whitePointObject = (PdfArray)this.getDictionary().get(PdfName.WhitePoint);
        return new double[]{((PdfNumber)whitePointObject.get(0)).getDoubleValue(), ((PdfNumber)whitePointObject.get(1)).getDoubleValue(), ((PdfNumber)whitePointObject.get(2)).getDoubleValue()};
    }

    protected final PdfDictionary getDictionary() {
        return (PdfDictionary)((PdfArray)this.getBaseDataObject()).get(1);
    }
}

