/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.tokens.ContentParser;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF10)
public final class Contents
extends PdfObjectWrapper<PdfDataObject>
implements List<ContentObject> {
    private List<ContentObject> items;
    private final IContentContext contentContext;

    public static Contents wrap(PdfDirectObject baseObject, IContentContext contentContext) {
        return baseObject != null ? new Contents(baseObject, contentContext) : null;
    }

    private Contents(PdfDirectObject baseObject, IContentContext contentContext) {
        super(baseObject);
        this.contentContext = contentContext;
        this.load();
    }

    @Override
    public Contents clone(Document context) {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    public void flush() {
        block3: {
            block2: {
                baseDataObject = this.getBaseDataObject();
                if (!(baseDataObject instanceof PdfStream)) break block2;
                stream = (PdfStream)baseDataObject;
                break block3;
            }
            streams = (PdfArray)baseDataObject;
            if (!streams.isEmpty()) ** GOTO lbl13
            stream = new PdfStream();
            streams.add(this.getFile().register(stream));
            break block3;
lbl-1000:
            // 1 sources

            {
                this.getFile().unregister((PdfReference)streams.remove(1));
lbl13:
                // 2 sources

                ** while (streams.size() > 1)
            }
lbl14:
            // 1 sources

            stream = (PdfStream)streams.resolve(0);
        }
        buffer = stream.getBody();
        buffer.setLength(0);
        context = this.getDocument();
        for (ContentObject item : this.items) {
            item.writeTo(buffer, context);
        }
    }

    public IContentContext getContentContext() {
        return this.contentContext;
    }

    @Override
    public void add(int index, ContentObject content) {
        this.items.add(index, content);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ContentObject> contents) {
        return this.items.addAll(index, contents);
    }

    @Override
    public ContentObject get(int index) {
        return this.items.get(index);
    }

    @Override
    public int indexOf(Object content) {
        return this.items.indexOf(content);
    }

    @Override
    public int lastIndexOf(Object content) {
        return this.items.lastIndexOf(content);
    }

    @Override
    public ListIterator<ContentObject> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator<ContentObject> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public ContentObject remove(int index) {
        return this.items.remove(index);
    }

    @Override
    public ContentObject set(int index, ContentObject content) {
        return this.items.set(index, content);
    }

    @Override
    public List<ContentObject> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(ContentObject content) {
        return this.items.add(content);
    }

    @Override
    public boolean addAll(Collection<? extends ContentObject> contents) {
        return this.items.addAll(contents);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public boolean contains(Object content) {
        return this.items.contains(content);
    }

    @Override
    public boolean containsAll(Collection<?> contents) {
        return this.items.containsAll(contents);
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean remove(Object content) {
        return this.items.remove(content);
    }

    @Override
    public boolean removeAll(Collection<?> contents) {
        return this.items.removeAll(contents);
    }

    @Override
    public boolean retainAll(Collection<?> contents) {
        return this.items.retainAll(contents);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        return this.items.toArray(contents);
    }

    @Override
    public Iterator<ContentObject> iterator() {
        return this.items.iterator();
    }

    private void load() {
        ContentParser parser = new ContentParser(new ContentStream((PdfDataObject)this.getBaseDataObject()));
        this.items = parser.parseContentObjects();
    }

    private static class ContentStream
    implements IInputStream {
        private final PdfDataObject baseDataObject;
        private long basePosition;
        private IInputStream stream;
        private int streamIndex = -1;

        public ContentStream(PdfDataObject baseDataObject) {
            this.baseDataObject = baseDataObject;
            this.moveNextStream();
        }

        @Override
        public long getLength() {
            if (this.baseDataObject instanceof PdfStream) {
                return ((PdfStream)this.baseDataObject).getBody().getLength();
            }
            int length = 0;
            for (PdfDirectObject stream : (PdfArray)this.baseDataObject) {
                length = (int)((long)length + ((PdfStream)((PdfReference)stream).getDataObject()).getBody().getLength());
            }
            return length;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public ByteOrder getByteOrder() {
            return this.stream.getByteOrder();
        }

        @Override
        public long getPosition() {
            return this.basePosition + this.stream.getPosition();
        }

        @Override
        public void read(byte[] data) throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public void read(byte[] data, int offset, int length) throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public byte readByte() throws EOFException {
            if (!(this.stream != null && this.stream.getPosition() < this.stream.getLength() || this.moveNextStream())) {
                throw new EOFException();
            }
            return this.stream.readByte();
        }

        @Override
        public int readInt() throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public int readInt(int length) throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public String readLine() throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public short readShort() throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public String readString(int length) throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public int readUnsignedByte() throws EOFException {
            if (!(this.stream != null && this.stream.getPosition() < this.stream.getLength() || this.moveNextStream())) {
                throw new EOFException();
            }
            return this.stream.readUnsignedByte();
        }

        @Override
        public int readUnsignedShort() throws EOFException {
            throw new NotImplementedException();
        }

        @Override
        public void seek(long position) {
            block2: {
                while (true) {
                    if (position < this.basePosition) {
                        if (this.movePreviousStream()) continue;
                        throw new IllegalArgumentException("The 'position' argument is lower than acceptable.");
                    }
                    if (position <= this.basePosition + this.stream.getLength()) break block2;
                    if (!this.moveNextStream()) break;
                }
                throw new IllegalArgumentException("The 'position' argument is higher than acceptable.");
            }
            this.stream.seek(position - this.basePosition);
        }

        @Override
        public void setByteOrder(ByteOrder value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPosition(long value) {
            this.seek(value);
        }

        @Override
        public void skip(long offset) {
            long position;
            block3: {
                while (true) {
                    if ((position = this.stream.getPosition() + offset) < 0L) {
                        offset += this.stream.getPosition();
                        if (!this.movePreviousStream()) {
                            throw new IllegalArgumentException("The 'offset' argument is lower than acceptable.");
                        }
                        this.stream.setPosition(this.stream.getLength());
                        continue;
                    }
                    if (position <= this.stream.getLength()) break block3;
                    offset -= this.stream.getLength() - this.stream.getPosition();
                    if (!this.moveNextStream()) break;
                }
                throw new IllegalArgumentException("The 'offset' argument is higher than acceptable.");
            }
            this.stream.seek(position);
        }

        @Override
        public byte[] toByteArray() {
            throw new NotImplementedException();
        }

        private boolean moveNextStream() {
            if (this.baseDataObject instanceof PdfStream) {
                if (this.streamIndex < 1) {
                    ++this.streamIndex;
                    this.basePosition = this.streamIndex == 0 ? 0L : this.basePosition + this.stream.getLength();
                    this.stream = this.streamIndex < 1 ? ((PdfStream)this.baseDataObject).getBody() : null;
                }
            } else {
                PdfArray streams = (PdfArray)this.baseDataObject;
                if (this.streamIndex < streams.size()) {
                    ++this.streamIndex;
                    this.basePosition = this.streamIndex == 0 ? 0L : this.basePosition + this.stream.getLength();
                    IInputStream iInputStream = this.stream = this.streamIndex < streams.size() ? ((PdfStream)streams.resolve(this.streamIndex)).getBody() : null;
                }
            }
            if (this.stream == null) {
                return false;
            }
            this.stream.setPosition(0L);
            return true;
        }

        private boolean movePreviousStream() {
            if (this.streamIndex == 0) {
                --this.streamIndex;
                this.stream = null;
            }
            if (this.streamIndex == -1) {
                return false;
            }
            --this.streamIndex;
            if (this.baseDataObject instanceof PdfStream) {
                this.stream = ((PdfStream)this.baseDataObject).getBody();
                this.basePosition = 0L;
            } else {
                PdfArray streams = (PdfArray)this.baseDataObject;
                this.stream = ((PdfStream)((PdfReference)streams.get(this.streamIndex)).getDataObject()).getBody();
                this.basePosition -= this.stream.getLength();
            }
            return true;
        }
    }
}

