/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF10)
public final class Pages
extends PdfObjectWrapper<PdfDictionary>
implements List<Page> {
    Pages(Document context) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.Kids, PdfName.Count}, new PdfDirectObject[]{PdfName.Pages, new PdfArray(), PdfInteger.Default}));
    }

    Pages(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Pages clone(Document context) {
        return (Pages)super.clone(context);
    }

    @Override
    public void add(int index, Page page) {
        this.commonAddAll(index, Arrays.asList(page));
    }

    @Override
    public boolean addAll(int index, Collection<? extends Page> pages) {
        return this.commonAddAll(index, pages);
    }

    @Override
    public Page get(int index) {
        int pageOffset = 0;
        PdfDictionary parent = (PdfDictionary)this.getBaseDataObject();
        PdfArray kids = (PdfArray)parent.resolve(PdfName.Kids);
        int i = 0;
        while (i < kids.size()) {
            PdfReference kidReference = (PdfReference)kids.get(i);
            PdfDictionary kid = (PdfDictionary)kidReference.getDataObject();
            if (kid.get(PdfName.Type).equals(PdfName.Page)) {
                if (pageOffset == index) {
                    return Page.wrap(kidReference);
                }
                ++pageOffset;
            } else if ((Integer)((PdfInteger)kid.get(PdfName.Count)).getRawValue() + pageOffset > index) {
                parent = kid;
                kids = (PdfArray)parent.resolve(PdfName.Kids);
                i = -1;
            } else {
                pageOffset += ((Integer)((PdfInteger)kid.get(PdfName.Count)).getRawValue()).intValue();
            }
            ++i;
        }
        return null;
    }

    @Override
    public int indexOf(Object page) {
        return ((Page)page).getIndex();
    }

    @Override
    public int lastIndexOf(Object page) {
        return this.indexOf(page);
    }

    @Override
    public ListIterator<Page> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<Page> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public Page remove(int index) {
        Page page = this.get(index);
        this.remove(page);
        return page;
    }

    @Override
    public Page set(int index, Page page) {
        Page old = this.remove(index);
        this.add(index, page);
        return old;
    }

    @Override
    public List<Page> subList(int fromIndex, int toIndex) {
        ArrayList<Page> pages = new ArrayList<Page>(toIndex - fromIndex);
        int i = fromIndex;
        while (i < toIndex) {
            pages.add(this.get(i++));
        }
        return pages;
    }

    @Override
    public boolean add(Page page) {
        return this.commonAddAll(-1, Arrays.asList(page));
    }

    @Override
    public boolean addAll(Collection<? extends Page> pages) {
        return this.commonAddAll(-1, pages);
    }

    @Override
    public void clear() {
        throw new NotImplementedException();
    }

    @Override
    public boolean contains(Object page) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsAll(Collection<?> pages) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        throw new NotImplementedException();
    }

    @Override
    public boolean remove(Object page) {
        Page pageObj = (Page)page;
        PdfDictionary pageData = (PdfDictionary)pageObj.getBaseDataObject();
        PdfDirectObject parent = pageData.get(PdfName.Parent);
        PdfDictionary parentData = (PdfDictionary)parent.resolve();
        PdfDirectObject kids = parentData.get(PdfName.Kids);
        PdfArray kidsData = (PdfArray)kids.resolve();
        kidsData.remove(pageObj.getBaseObject());
        pageData.put(PdfName.Parent, null);
        do {
            PdfInteger countObject = (PdfInteger)parentData.get(PdfName.Count);
            parentData.put(PdfName.Count, PdfInteger.get(countObject.getValue() - 1));
            parent = parentData.get(PdfName.Parent);
            parentData = (PdfDictionary)PdfObject.resolve(parent);
        } while (parent != null);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> pages) {
        boolean changed = false;
        for (Object page : pages) {
            changed |= this.remove(page);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> pages) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        return (Integer)((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Count)).getRawValue();
    }

    public Page[] toArray() {
        throw new NotImplementedException();
    }

    @Override
    public <T> T[] toArray(T[] pages) {
        throw new NotImplementedException();
    }

    @Override
    public Iterator<Page> iterator() {
        return new Iterator<Page>(){
            private int index = 0;
            private final int size;
            private int levelIndex;
            private final Stack<Integer> levelIndexes;
            private PdfDictionary parent;
            private PdfArray kids;
            {
                this.size = Pages.this.size();
                this.levelIndex = 0;
                this.levelIndexes = new Stack();
                this.parent = (PdfDictionary)Pages.this.getBaseDataObject();
                this.kids = (PdfArray)this.parent.resolve(PdfName.Kids);
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Page next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (true) {
                    if (this.kids.size() == this.levelIndex) {
                        this.levelIndex = this.levelIndexes.pop() + 1;
                        this.parent = (PdfDictionary)this.parent.resolve(PdfName.Parent);
                        this.kids = (PdfArray)this.parent.resolve(PdfName.Kids);
                        continue;
                    }
                    PdfReference kidReference = (PdfReference)this.kids.get(this.levelIndex);
                    PdfDictionary kid = (PdfDictionary)kidReference.getDataObject();
                    if (kid.get(PdfName.Type).equals(PdfName.Page)) {
                        ++this.index;
                        ++this.levelIndex;
                        return Page.wrap(kidReference);
                    }
                    this.levelIndexes.push(this.levelIndex);
                    this.parent = kid;
                    this.kids = (PdfArray)this.parent.resolve(PdfName.Kids);
                    this.levelIndex = 0;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private boolean commonAddAll(int index, Collection<? extends Page> pages) {
        int offset;
        PdfArray kidsData;
        PdfDirectObject kids;
        PdfDictionary parentData;
        PdfDirectObject parent;
        if (index == -1) {
            parent = this.getBaseObject();
            parentData = (PdfDictionary)this.getBaseDataObject();
            kids = parentData.get(PdfName.Kids);
            kidsData = (PdfArray)PdfObject.resolve(kids);
            offset = 0;
        } else {
            Page page = this.get(index);
            parent = ((PdfDictionary)page.getBaseDataObject()).get(PdfName.Parent);
            parentData = (PdfDictionary)parent.resolve();
            kids = parentData.get(PdfName.Kids);
            kidsData = (PdfArray)kids.resolve();
            offset = kidsData.indexOf(page.getBaseObject());
        }
        for (Page page : pages) {
            if (index == -1) {
                kidsData.add(page.getBaseObject());
            } else {
                kidsData.add(offset++, page.getBaseObject());
            }
            ((PdfDictionary)page.getBaseDataObject()).put(PdfName.Parent, parent);
        }
        do {
            PdfInteger pdfInteger = (PdfInteger)parentData.get(PdfName.Count);
            parentData.put(PdfName.Count, PdfInteger.get(pdfInteger.getValue() + pages.size()));
            parent = parentData.get(PdfName.Parent);
            parentData = (PdfDictionary)PdfObject.resolve(parent);
        } while (parent != null);
        return true;
    }
}

